/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.eventsusage.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.analytics.usecases.eventsusage.contracts.EventCounterManager;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalUnassignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import org.springframework.beans.factory.annotation.Qualifier;

public class ApprovalEventsAnalyticsListener
extends WorkflowsListener {
    private final EventCounterManager approvalEventCounterUseCase;
    private final EventCounterManager totalEventCounterUseCase;

    public ApprovalEventsAnalyticsListener(EventPublisher eventPublisher, @Qualifier(value="approvalEventCounterUseCase") EventCounterManager approvalEventCounterUseCase, @Qualifier(value="totalEventCounterUseCase") EventCounterManager totalEventCounterUseCase) {
        super(eventPublisher);
        this.approvalEventCounterUseCase = approvalEventCounterUseCase;
        this.totalEventCounterUseCase = totalEventCounterUseCase;
    }

    @EventListener
    public void onPageApprovalApproveEvent(PageApprovalApproveEvent event) {
        if (event.isPartial()) {
            this.incrementCounters();
        }
    }

    @EventListener
    public void onBlogPostApprovalApproveEvent(BlogPostApprovalApproveEvent event) {
        if (event.isPartial()) {
            this.incrementCounters();
        }
    }

    @EventListener
    public void onPageApprovalRejectEvent(PageApprovalRejectEvent event) {
        if (event.isPartial()) {
            this.incrementCounters();
        }
    }

    @EventListener
    public void onBlogPostApprovalRejectEvent(BlogPostApprovalRejectEvent event) {
        if (event.isPartial()) {
            this.incrementCounters();
        }
    }

    @EventListener
    public void onPageApprovalAssignedEvent(PageApprovalAssignedEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onBlogPostApprovalAssignedEvent(BlogPostApprovalAssignedEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onDefaultApprovalUnassignedEvent(DefaultApprovalUnassignedEvent event) {
        this.incrementCounters();
    }

    private void incrementCounters() {
        this.totalEventCounterUseCase.increment();
        this.approvalEventCounterUseCase.increment();
    }
}

