/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.DateUtils;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import java.util.Calendar;
import java.util.Date;

public class FancyDateFormatter {
    public static String decorateDateTimePretty(Date date, boolean time) {
        String dateStr;
        long millis = date.getTime();
        if (millis >= FancyDateFormatter.today()) {
            if (millis < FancyDateFormatter.endOfToday()) {
                return ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.date.at", (Object[])new String[]{FancyDateFormatter.getDateFormatter().formatTime(date)});
            }
            dateStr = millis < FancyDateFormatter.endofTomorrow() ? ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.date.tomorrow") : ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.date.on", (Object[])new String[]{FancyDateFormatter.getDateFormatter().format(date)});
        } else {
            dateStr = millis >= FancyDateFormatter.yesterday() ? ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.date.yesterday") : ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.date.on", (Object[])new String[]{FancyDateFormatter.getDateFormatter().format(date)});
        }
        if (!time) {
            return dateStr;
        }
        return dateStr + " " + ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.info.date.at", (Object[])new String[]{FancyDateFormatter.getDateFormatter().formatTime(date)});
    }

    public static long today() {
        return DateUtils.toStartOfPeriod((Calendar)Calendar.getInstance(), (int)5).getTime().getTime();
    }

    public static long yesterday() {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.yesterday());
        return DateUtils.toStartOfPeriod((Calendar)c, (int)5).getTime().getTime();
    }

    public static long endOfToday() {
        return DateUtils.tomorrow().getTime() - 1L;
    }

    public static long endofTomorrow() {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.tomorrow());
        return DateUtils.toEndOfPeriod((Calendar)c, (int)5).getTime().getTime();
    }

    public static DateFormatter getDateFormatter() {
        ConfluenceUserPreferences preferences;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && !WorkflowsFeatureManagerImpl.isWorkflowsUser(user.getName()) && (preferences = FancyDateFormatter.getUserAccessor().getConfluenceUserPreferences((User)user)) != null) {
            return preferences.getDateFormatter(FancyDateFormatter.getFormatSettingsManager(), FancyDateFormatter.getLocaleManager());
        }
        TimeZone timeZone = TimeZone.getDefault();
        return new DateFormatter(timeZone, FancyDateFormatter.getFormatSettingsManager(), null);
    }

    public static UserAccessor getUserAccessor() {
        return (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
    }

    public static FormatSettingsManager getFormatSettingsManager() {
        return (FormatSettingsManager)ComponentLocator.getComponent(FormatSettingsManager.class);
    }

    private static LocaleManager getLocaleManager() {
        return (LocaleManager)ContainerManager.getComponent((String)"localeManager");
    }
}

