/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.messaging;

import com.atlassian.confluence.compat.setup.xstream.XStreamManagerCompat;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMessageManager {
    private static final Logger log = LoggerFactory.getLogger(PageMessageManager.class);
    public static final RenderMode RENDER_MODE = RenderMode.suppress((long)256L);
    private static final String MESSAGE_KEY_BOTH = "com.comalatech.message.";
    private static final String MESSAGE_KEY_PUBLISHED = "com.comalatech.message.published.";
    private static final String MESSAGE_KEY_DRAFT = "com.comalatech.message.draft.";
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final PersonalInformationManager personalInformationManager;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final UserAccessor userAccessor;
    private final UsersListResolver usersListResolver;
    private final XStreamManagerCompat xStreamManagerCompat;
    private final EntityManagerProvider entityManagerProvider;

    public PageMessageManager(ComalaPropertiesSetManager contentPropertyManager, PersonalInformationManager personalInformationManager, WikiStyleRenderer wikiStyleRenderer, UserAccessor userAccessor, UsersListResolver usersListResolver, XStreamManagerCompat xStreamManagerCompat, EntityManagerProvider entityManagerProvider) {
        this.contentPropertyManager = contentPropertyManager;
        this.personalInformationManager = personalInformationManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.userAccessor = userAccessor;
        this.usersListResolver = usersListResolver;
        this.xStreamManagerCompat = xStreamManagerCompat;
        this.entityManagerProvider = entityManagerProvider;
    }

    public void setMessage(AbstractPage page, String title, String message, String style, long ttlInSeconds) {
        this.setMessage(page, title, message, style, ttlInSeconds, null);
    }

    public void setMessage(AbstractPage page, String title, ConfluenceUser user, String message, String style, long ttlInSeconds) {
        this.setMessage(page, title, user, message, style, ttlInSeconds, null);
    }

    public void setMessage(AbstractPage page, String title, String message, String style, long ttlInSeconds, String view) {
        if (view == null) {
            view = Message.MessageView.BOTH.name;
        }
        String rawMessage = TextUtils.stringSet((String)message) ? this.makeMessageXml(title, message, style, ttlInSeconds, view) : "";
        if (log.isDebugEnabled()) {
            log.debug("Set message: " + title + "/" + message);
        }
        this.contentPropertyManager.setTextProperty((ContentEntityObject)page, this.makeKey(view), rawMessage);
    }

    public void setMessage(AbstractPage page, String title, ConfluenceUser user, String message, String style, long ttlInSeconds, String view) {
        if (!this.userAccessor.isDeactivated(user.getName())) {
            if (view == null) {
                view = Message.MessageView.BOTH.name;
            }
            String rawMessage = TextUtils.stringSet((String)message) ? this.makeMessageXml(title, message, style, ttlInSeconds, view) : "";
            if (log.isDebugEnabled()) {
                log.debug("Set message for USER " + user.getName() + ": " + title + "/" + message);
            }
            this.contentPropertyManager.setTextProperty((ContentEntityObject)this.personalInformationManager.getOrCreatePersonalInformation((User)user), this.makePageKey(page, view), rawMessage);
        }
    }

    public void setMessage(AbstractPage page, String title, Group group, String message, String style, long ttlInSeconds, String view) {
        if (log.isDebugEnabled()) {
            log.debug("Set message for GROUP (limited users defined in resolver) " + group.getName() + ": " + title + "/" + message);
        }
        try {
            for (String username : this.usersListResolver.getUsersFromGroup(group.getName(), null)) {
                ConfluenceUser user = this.userAccessor.getUserByName(username);
                this.setMessage(page, title, user, message, style, ttlInSeconds, view);
            }
        }
        catch (Exception e) {
            log.error("Workflow Error getting group members for group: " + group, (Throwable)e);
        }
    }

    public Message getBothMessage(AbstractPage page, boolean flush) {
        return this.getCeoMessage((ContentEntityObject)page, MESSAGE_KEY_BOTH, flush);
    }

    public Message getDraftMessage(AbstractPage page, boolean flush) {
        return this.getCeoMessage((ContentEntityObject)page, MESSAGE_KEY_DRAFT, flush);
    }

    public Message getPublicMessage(AbstractPage page, boolean flush) {
        return this.getCeoMessage((ContentEntityObject)page, MESSAGE_KEY_PUBLISHED, flush);
    }

    public Message getBothMessage(AbstractPage page, ConfluenceUser user, boolean flush) {
        if (user == null) {
            return null;
        }
        return this.getCeoMessage((ContentEntityObject)this.personalInformationManager.getOrCreatePersonalInformation((User)user), this.getBothKey(page), flush);
    }

    public Message getDraftMessage(AbstractPage page, ConfluenceUser user, boolean flush) {
        if (user == null) {
            return null;
        }
        return this.getCeoMessage((ContentEntityObject)this.personalInformationManager.getOrCreatePersonalInformation((User)user), this.getDraftKey(page), flush);
    }

    public Message getPublicMessage(AbstractPage page, ConfluenceUser user, boolean flush) {
        if (user == null) {
            return null;
        }
        return this.getCeoMessage((ContentEntityObject)this.personalInformationManager.getOrCreatePersonalInformation((User)user), this.getPublichKey(page), flush);
    }

    public void removePageMessages(AbstractPage page) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, MESSAGE_KEY_BOTH);
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, MESSAGE_KEY_PUBLISHED);
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, MESSAGE_KEY_DRAFT);
    }

    public void removeUserMessages(List<String> pageIds) {
        for (String pageId : pageIds) {
            String deleteQuery = "DELETE FROM OS_PROPERTYENTRY WHERE entity_key LIKE " + String.format("'com.comalatech.message.%%%s'", pageId);
            this.entityManagerProvider.getEntityManager().createNativeQuery(deleteQuery).executeUpdate();
        }
    }

    private String makeMessageXml(String title, String message, String style, long ttlInSeconds, String view) {
        Message daMessage = new Message(title, message, style, ttlInSeconds, view);
        return this.xStreamManagerCompat.toXML(daMessage);
    }

    private String makeKey(String view) {
        if (view.equals(Message.MessageView.PUBLISHED.name)) {
            return MESSAGE_KEY_PUBLISHED;
        }
        if (view.equals(Message.MessageView.DRAFT.name)) {
            return MESSAGE_KEY_DRAFT;
        }
        return MESSAGE_KEY_BOTH;
    }

    private String makePageKey(AbstractPage page, String view) {
        return this.makeKey(view) + page.getIdAsString();
    }

    private String getBothKey(AbstractPage page) {
        return MESSAGE_KEY_BOTH + page.getIdAsString();
    }

    private String getDraftKey(AbstractPage page) {
        return MESSAGE_KEY_DRAFT + page.getIdAsString();
    }

    private String getPublichKey(AbstractPage page) {
        return MESSAGE_KEY_PUBLISHED + page.getIdAsString();
    }

    private Message getCeoMessage(ContentEntityObject ceo, String key, boolean flush) {
        String rawMessage = this.contentPropertyManager.getTextProperty(ceo, key);
        if (rawMessage == null || rawMessage.trim().length() == 0) {
            return null;
        }
        Message message = (Message)this.xStreamManagerCompat.fromXML(rawMessage);
        if (flush) {
            if (message.isShowOnce()) {
                if (message.isShown()) {
                    this.contentPropertyManager.setTextProperty(ceo, key, null);
                }
            } else if (message.isExpired()) {
                this.contentPropertyManager.setTextProperty(ceo, key, null);
                return null;
            }
        }
        if (ceo instanceof PersonalInformation && !message.isShown()) {
            message.setShown(true);
            this.contentPropertyManager.setTextProperty(ceo, key, this.xStreamManagerCompat.toXML(message));
        }
        if (message.isCaption() && ceo instanceof AbstractPage) {
            this.renderMessage(message, (AbstractPage)ceo);
        }
        return message;
    }

    private void renderMessage(Message message, AbstractPage page) {
        PageContext context = page.toPageContext();
        context.pushRenderMode(RENDER_MODE);
        message.setRenderedMessage(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, message.getMessage()).trim());
    }
}

