/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.service.mapper;

import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.upgrade.accessor.entity.PreCheckRecord;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheck;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheckStatus;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;

public class PreCheckMapper {
    private final LongRunningTaskManager longRunningTaskManager;
    private static final String SUPPORT_DOWNLOAD_LINK = "/rest/cw/2/documentactivity/upgrade/support/";

    public PreCheckMapper(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public PreCheck fromRecordToModel(PreCheckRecord preCheckRecord, Space space) {
        PreCheck preCheck = new PreCheck();
        if (preCheckRecord != null) {
            preCheck.setStatus(preCheckRecord.getStatus());
            preCheck.setDuration(preCheckRecord.getDuration());
            preCheck.setNumErrors(preCheckRecord.getNumErrors());
            preCheck.setStartedAt(preCheckRecord.getStartedAt());
            String taskId = preCheckRecord.getLongRunningTaskId();
            if (taskId != null) {
                LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
                LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
                if (longRunningTask != null) {
                    preCheck.setProgress(longRunningTask.getPercentageComplete());
                }
            }
            if (PreCheckStatus.FAIL.equals((Object)preCheckRecord.getStatus())) {
                preCheck.setSupport(SUPPORT_DOWNLOAD_LINK + space.getKey());
            }
        } else {
            preCheck.setStatus(PreCheckStatus.NOT_RUN);
        }
        return preCheck;
    }

    public PreCheckRecord fromModelToRecord(PreCheck preCheck) {
        PreCheckRecord preCheckRecord = new PreCheckRecord();
        if (preCheck != null) {
            preCheckRecord.setStatus(preCheck.getStatus());
            preCheckRecord.setDuration(preCheck.getDuration());
            preCheckRecord.setNumErrors(preCheck.getNumErrors());
            preCheckRecord.setLongRunningTaskId(preCheck.getLongRunningTaskId());
            preCheckRecord.setStartedAt(preCheck.getStartedAt());
        }
        return preCheckRecord;
    }
}

