/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.cloud.migration.events.MigrationAssessmentScreenEvent;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.analytics.DispatcherAnalyticsManager;
import com.comalatech.confluence.workflow.analytics.catalog.BandanaKeysCatalog;
import com.comalatech.confluence.workflow.analytics.usecases.appsusagesharing.AppUsageShareOnDemandGenerationUseCase;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;

public class MigrationAssessmentAction
extends ConfluenceActionSupport {
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private DispatcherAnalyticsManager dispatcherAnalyticsManager;
    private PageManager pageManager;
    private AppUsageShareOnDemandGenerationUseCase appUsageShareOnDemandGenerationUseCase;
    private EventPublisher eventPublisher;
    private static final String RECENT_APPROVAL_DATE_FORMAT = "yyyy-MM-dd HH:mm";

    public String execute() throws Exception {
        this.eventPublisher.publish((Object)new MigrationAssessmentScreenEvent());
        return "success";
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public boolean isMigrationAssessmentEnabled() {
        return this.workflowStatisticsManager.isMigrationAssessmentEnabled();
    }

    public long getActivePages() {
        return this.dispatcherAnalyticsManager.getActivePages();
    }

    public long getTotalPages() {
        return this.dispatcherAnalyticsManager.getTotalPages();
    }

    public long getActiveSpaces() {
        return this.dispatcherAnalyticsManager.getActiveSpaces();
    }

    public long getTotalSpaces() {
        return this.dispatcherAnalyticsManager.getTotalSpaces();
    }

    public String getRecentApprovalContent() {
        String contentId = (String)this.dispatcherAnalyticsManager.getAnalyticsEntry(BandanaKeysCatalog.LATEST_CONTENT_APPROVED_OR_REJECTED_KEY);
        if (contentId != null) {
            Page page = this.pageManager.getPage(Long.valueOf(contentId).longValue());
            return page != null ? page.getTitle() : "";
        }
        return "";
    }

    public String getRecentApprovalDate() {
        Long date = this.dispatcherAnalyticsManager.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVED_OR_REJECTED_KEY);
        if (date != null && date != 0L) {
            return DateFormatUtils.format((long)date, (String)RECENT_APPROVAL_DATE_FORMAT);
        }
        return "";
    }

    public String getAppUsageData() {
        String appUsageData = this.appUsageShareOnDemandGenerationUseCase.generateAppUsage();
        if (appUsageData != null) {
            return new JSONObject(appUsageData).toString(4);
        }
        return "";
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public void setDispatcherAnalyticsManager(DispatcherAnalyticsManager dispatcherAnalyticsManager) {
        this.dispatcherAnalyticsManager = dispatcherAnalyticsManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setAppUsageShareOnDemandGenerationUseCase(AppUsageShareOnDemandGenerationUseCase appUsageShareOnDemandGenerationUseCase) {
        this.appUsageShareOnDemandGenerationUseCase = appUsageShareOnDemandGenerationUseCase;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

