/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};

Adhoc.Form = Adhoc.Form || {};

Adhoc.menuActions = Adhoc.menuActions || [];

(function ($) {

    Adhoc.Form.toggleEdit = function() {
        $("#workflow-form").toggleClass("edit");
        return false;
    };

    Adhoc.Form.doSubmitForm = function() {
        var formRequest = {
            fields : []
        };
        var inputFields = $(this).parents("form").find("table input");
        inputFields.each(function() {
            formRequest.fields.push({
                id: $(this).attr("name"),
                value: $(this).attr("value")
            });
        });
        var selectFields = $(this).parents("form").find("table select");
        selectFields.each(function() {
            formRequest.fields.push({
                id: $(this).attr("name"),
                value: $("option:selected",$(this)).text()
            });
        });

        Adhoc.submitProgress($(this).parents(".adhoc"));
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/forms/" + AJS.params.pageId + "/submit",
            data: JSON.stringify(formRequest),
            success: function (pageStatus, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    var stateChanged = Adhoc.state.stateName != pageStatus.stateName;
                    Adhoc.Workflow.setState(pageStatus);
                    $("#adhocWorkflowsLink").click();
                } else {
                    Adhoc.dialog.hide();
                }
            },
            error: Adhoc.errorHandler
        });
        return false;
    };

    Adhoc.Form.doFormDialog = function(action, $contents) {
        var inputFields = action.inputFields;
        $contents.append(AJS.template.load("adhocworkflows-form").fill());
        var formTable = $contents.find(".ahoc-form table");
        for (i = 0; i < inputFields.length;i++) {
            var inputField = inputFields[i];
            formTable.append(AJS.template.load("adhocworkflows-inputfield").fill(inputField));
            var value = $contents.find("#" + inputField.id);
            if (inputField.type == "USER") {
                value.append(AJS.template.load("adhocworkflows-inputfield-user").fill(inputField));
                $.ajax({
                    type: "GET",
                    cache: false,
                    url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/forms/user/" + value.find("span").html(),
                    success: function (user, textStatus, jqXHR) {
                        if (jqXHR.status != 200) {
                            return;
                        }
                        $contents.find("span[title='" + user.name + "']").html("").append(AJS.template.load("adhocworkflows-inputfield-decorated-user").fill(user));
                    },
                    error: Adhoc.errorHandler
                });
            } else if (inputField.type == "LIST") {
                value.append(AJS.template.load("adhocworkflows-inputfield-list").fill(inputField));
                for (j = 0; j < inputField.options.length;j++) {
                    value.find("select").append(AJS.template.load("adhocworkflows-inputfield-list-option").fill(
                            {option: inputField.options[j],
                             selected: (inputField.options[j] == inputField.value ? "selected='selected'" : "")
                            }));
                }
            } else {
                value.append(AJS.template.load("adhocworkflows-inputfield-text").fill(inputField));
            }
        }
        $contents.find(".edit-form").click(Adhoc.Form.toggleEdit);
        if (action.initParameters) {
            $contents.find(".edit-form").click();
        }
        $contents.find("input[type='submit']").click(Adhoc.Form.doSubmitForm);
        $contents.find(".cancel-dialog").click(Adhoc.doHidePopup);
        Adhoc.setPresetUsers($("#inline-dialog-adhocWorkflowsPopup .usersdropdown .aui-dropdown"),action.involvedUsers);
        $contents.find("input.autocomplete-user").click(function() {
            $(this).parents("td").find(".usersdropdown a.aui-dd-trigger").click();
        });
        $contents.find(".usersdropdown").dropDown("Standard");
    }

    Adhoc.Form.showParameters = function() {
        Adhoc.action.showParameters = true;
        Adhoc.generateActionDialog(Adhoc.dialog.find("div.contents"),Adhoc.action);
        return false;
    }

})(AJS.$);

