/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.user;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.Map;
import org.randombits.confluence.filtering.criteria.AutowiredCriterion;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpacePermissionCriterion
extends AutowiredCriterion {
    private PermissionManager permissionManager;
    private String spaceKey;
    private Permission permission;
    private Class<?> createClass;
    private SpaceManager spaceManager;
    private UserAccessor userAccessor;

    public SpacePermissionCriterion(String spaceKey, Class<?> createClass) {
        this.spaceKey = spaceKey;
        this.createClass = createClass;
    }

    public SpacePermissionCriterion(String spaceKey, Permission permission) {
        this.spaceKey = spaceKey;
        this.permission = permission;
    }

    @Override
    public boolean matches(Object object) {
        User user = null;
        if (object instanceof User) {
            user = (User)object;
        } else if (object instanceof String) {
            user = this.userAccessor.getUser((String)object);
        } else if (object != null) {
            return false;
        }
        if (this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return true;
        }
        Space space = this.spaceManager.getSpace(this.spaceKey);
        if (space != null) {
            if (this.permission != null) {
                return this.permissionManager.hasPermission(user, this.permission, (Object)space);
            }
            return this.permissionManager.hasCreatePermission(user, (Object)space, this.createClass);
        }
        return false;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String toString() {
        return "{space: " + this.spaceKey + (this.createClass == null ? "" : "; create class: " + this.createClass.getSimpleName()) + (this.permission == null ? "" : "; permission: " + this.permission) + "}";
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public static final String EDIT_PAGE = "edit";
        public static final String SPACE_ADMIN = "admin";
        private static final String SPACE_BLOG = "blog";
        public static final String SPACE_NEWS = "news";
        public static final String SPACE_VIEW = "view";
        public static final String SPACE_COMMENT = "comment";
        private static final String SELF_SPACE = "@space";
        private static final Map<String, Object> ACTIONS = new HashMap<String, Object>(4);
        private Space space;

        public Interpreter(Space space) {
            this.space = space;
        }

        public Space getSpace() {
            return this.space;
        }

        public Criterion createCriterion(String value) throws CriteriaException {
            Object action;
            String spaceKey = value;
            int splitAt = spaceKey.indexOf(62);
            if (splitAt == -1) {
                splitAt = spaceKey.indexOf(58);
            }
            if (splitAt != -1) {
                action = ACTIONS.get(spaceKey.substring(splitAt + 1).toLowerCase().trim());
                spaceKey = spaceKey.substring(0, splitAt).trim();
                if (action == null) {
                    throw new IllegalArgumentException("The permission requested is not recognised: " + value);
                }
            } else {
                action = Permission.VIEW;
            }
            if (SELF_SPACE.equals(spaceKey)) {
                if (this.space != null) {
                    this.space.getKey();
                } else {
                    throw new CriteriaException("@space cannot be used in this context.");
                }
            }
            if (action instanceof Permission) {
                return new SpacePermissionCriterion(spaceKey, (Permission)action);
            }
            if (action instanceof Class) {
                return new SpacePermissionCriterion(spaceKey, (Class)action);
            }
            throw new CriteriaException("Unsupported space permission: " + value);
        }

        static {
            ACTIONS.put(SPACE_VIEW, Permission.VIEW);
            ACTIONS.put(SPACE_ADMIN, Permission.ADMINISTER);
            ACTIONS.put(EDIT_PAGE, Page.class);
            ACTIONS.put(SPACE_BLOG, BlogPost.class);
            ACTIONS.put(SPACE_NEWS, BlogPost.class);
            ACTIONS.put(SPACE_COMMENT, Comment.class);
        }
    }
}

