/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.macro;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.v2.macro.MacroException;
import net.customware.confluence.reporting.ExecutionException;
import net.customware.confluence.reporting.Executor;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.macro.AbstractReportingMacro;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.filtering.param.content.ConfluenceEntityParameter;
import org.randombits.confluence.supplier.SupplierAssistant;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;
import org.randombits.confluence.support.MacroInfo;
import org.randombits.storage.IndexedStorage;

public abstract class AbstractValueMacro
extends AbstractReportingMacro {
    protected static final String KEY_PARAM = "key";

    protected String report(final MacroInfo info) throws MacroException, ReportException {
        final Object source = this.getSource(info);
        PageContext ctx = info.getPageContext();
        if (source instanceof ContentEntityObject && (ctx == null || !source.equals(info.getContent()))) {
            ctx = ((ContentEntityObject)source).toPageContext();
        }
        return ReportBuilder.executeRoot(ctx, new Executor<String>(){

            @Override
            public String execute() throws ReportException {
                String key = AbstractValueMacro.this.getKey(info);
                key = key != null && key.trim().length() == 0 ? null : key;
                try {
                    Object value = AbstractValueMacro.this.getValue(info, source, key);
                    return AbstractValueMacro.this.report(source, key, value, info);
                }
                catch (UnsupportedContextException e) {
                    throw new ExecutionException(e.getMessage(), e);
                }
                catch (SupplierException e) {
                    throw new ExecutionException(e.getMessage(), e);
                }
            }
        });
    }

    protected Object getValue(MacroInfo info, Object source, String key) throws ReportException {
        try {
            return SupplierAssistant.getInstance().findValue(source, key);
        }
        catch (SupplierException e) {
            throw new ExecutionException(e.getMessage(), e);
        }
        catch (UnsupportedContextException e) {
            throw new ExecutionException(e.getMessage(), e);
        }
    }

    protected String getKey(MacroInfo info) {
        IndexedStorage params = info.getMacroParams();
        return params.getString(KEY_PARAM, params.getString(0, this.getDefaultKey()));
    }

    protected String getDefaultKey() {
        return null;
    }

    protected Object getSource(MacroInfo info) throws ReportException {
        Object source;
        try {
            source = new ConfluenceEntityParameter(null, "source").findEntity(info);
        }
        catch (ParameterException e) {
            throw new ExecutionException(e);
        }
        if (source == null) {
            source = ReportBuilder.getCurrentSource(info.getContent());
        }
        if (source == null) {
            throw new ExecutionException("Unable to find a source to report on.");
        }
        return source;
    }

    protected abstract String report(Object var1, String var2, Object var3, MacroInfo var4) throws ReportException, SupplierException, UnsupportedContextException;
}

