/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.transformer;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.transformer.AbstractTransformer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMacroDefinitionsTransformer
extends AbstractTransformer {
    private static final Logger log = LoggerFactory.getLogger(UpdateMacroDefinitionsTransformer.class);
    private final AttachmentManager attachmentManager;
    private final XhtmlContent xhtmlContent;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final ApprovalAccessor approvalAccessor;

    public UpdateMacroDefinitionsTransformer(AttachmentManager attachmentManager, XhtmlContent xhtmlContent, WorkflowConfigurationManager workflowConfigurationManager, ApprovalAccessor approvalAccessor) {
        this.attachmentManager = attachmentManager;
        this.xhtmlContent = xhtmlContent;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.approvalAccessor = approvalAccessor;
    }

    @Override
    public boolean shouldApply(String content, ConversionContext context) {
        return !context.hasProperty("snapshots-mode");
    }

    @Override
    public String transform(String content, ConversionContext context) throws XhtmlException {
        try {
            content = this.xhtmlContent.updateMacroDefinitions(content, context, (MacroDefinitionUpdater)new GiffyAndExcerptMacroUpdater(context));
        }
        catch (Exception e) {
            log.warn("Error while transforming Gliffy or ExcerptMacro " + context.getEntity(), (Throwable)e);
        }
        return content;
    }

    protected class GiffyAndExcerptMacroUpdater
    implements MacroDefinitionUpdater {
        private final ConversionContext context;

        private GiffyAndExcerptMacroUpdater(ConversionContext context) {
            this.context = context;
        }

        public MacroDefinition update(MacroDefinition macroDefinition) {
            if (this.context.getProperty("releaseview") != null && macroDefinition.getName().equalsIgnoreCase("gliffy")) {
                try {
                    this.updateGliffyMacro(macroDefinition);
                }
                catch (Exception e) {
                    log.warn("Error while transforming Gliffy Macro " + this.context.getEntity(), (Throwable)e);
                }
            }
            if (UpdateMacroDefinitionsTransformer.this.workflowConfigurationManager.isMacroTransformEnable(this.context.getSpaceKey())) {
                try {
                    this.updateExcerptMacro(macroDefinition);
                }
                catch (Exception e) {
                    log.warn("Error while transforming ExcerptMacro " + this.context.getEntity(), (Throwable)e);
                }
            }
            return macroDefinition;
        }

        protected void updateGliffyMacro(MacroDefinition macroDefinition) {
            if (log.isDebugEnabled()) {
                log.debug("found gliffy macro:" + macroDefinition);
            }
            Map macroDefinitionParameters = macroDefinition.getParameters();
            String gliffyName = (String)macroDefinitionParameters.get("name");
            Object gliffyVersion = macroDefinitionParameters.get("version");
            if (gliffyVersion == null) {
                ArrayList publishedAttachemtsList;
                ApprovalCheck.CheckedAttachment checkedAttachment;
                AbstractPage content = (AbstractPage)this.context.getEntity();
                ApprovalCheck.CheckedAttachment[] publishedAttachments = null;
                if (content != null) {
                    ApprovalCheck approvalCheck = UpdateMacroDefinitionsTransformer.this.approvalAccessor.getFinalApprovalCheck(content.getLatestVersion());
                    if (approvalCheck != null) {
                        publishedAttachments = approvalCheck.getAttachments();
                    } else {
                        log.warn("Final ApprovalCheck does not exist for content: " + content.getIdAsString());
                    }
                }
                if (publishedAttachments != null && publishedAttachments.length > 0 && null != (checkedAttachment = (ApprovalCheck.CheckedAttachment)(publishedAttachemtsList = Lists.newArrayList(publishedAttachments)).stream().filter(input -> {
                    Attachment attachment = UpdateMacroDefinitionsTransformer.this.attachmentManager.getAttachment(input.getId());
                    return attachment != null && !attachment.getFileName().contains(".") && gliffyName.equalsIgnoreCase(attachment.getFileName());
                }).findFirst().orElse(null))) {
                    Map updatedParameters = macroDefinition.getTypedParameters();
                    updatedParameters.put("version", checkedAttachment.getVersion() + "");
                    macroDefinition.setTypedParameters(updatedParameters);
                }
            }
        }

        protected void updateExcerptMacro(MacroDefinition macroDefinition) {
            if (macroDefinition.getName().equals("excerpt-include")) {
                macroDefinition.setName("awp-excerpt-include");
            }
            if (macroDefinition.getName().equals("include")) {
                macroDefinition.setName("awp-include");
            }
        }
    }
}

