/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.MarkupValidationException;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflowTranslation;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.workflow.WorkflowException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestResource.class);
    protected static final String APPLICATION_PERMISSION_ERROR = "The application has no permission over ";
    protected final PermissionManager permissionManager;
    protected final SpaceManager spaceManager;
    protected final PageManager pageManager;
    protected final WorkflowMarkupManager workflowMarkupManager;
    protected WorkflowsFeatureManager workflowsFeatureManager;

    public AbstractRestResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.workflowMarkupManager = workflowMarkupManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    protected Response getSingleWorkflowResponse(List<com.comalatech.workflow.model.Workflow> workflowsList, String workflowId) {
        try {
            Optional<RestWorkflow> optionalRestWorkflow = workflowsList.stream().filter(w -> ((Workflow)w).getHandle().equals(workflowId)).peek(this::moveReadAckMacroOutsideState).map(this::toRest).findFirst();
            if (optionalRestWorkflow.isPresent()) {
                return Response.ok((Object)optionalRestWorkflow.get()).build();
            }
            return Response.noContent().build();
        }
        catch (MapperException ex) {
            return this.handleException(ex);
        }
    }

    protected RestWorkflow toRest(com.comalatech.workflow.model.Workflow workflow) {
        String workflowHandle = ((Workflow)workflow).getHandle();
        RestWorkflow restWorkflow = Mappers.workflowMapper.toRest((Workflow)workflow);
        restWorkflow.key = workflowHandle;
        try {
            this.workflowMarkupManager.validateJsonMarkup(restWorkflow);
        }
        catch (MarkupValidationException ex) {
            log.debug("Validation error in the markup generated");
            ex.getErrors().forEach(error -> log.debug("  - " + error));
        }
        return restWorkflow;
    }

    protected <T> T toAbstractRest(com.comalatech.workflow.model.Workflow workflow) {
        RestWorkflow restWorkflow = this.toRest(workflow);
        if (StringUtils.isNotBlank((CharSequence)workflow.getName()) && this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            String workflowName = StringUtils.deleteWhitespace((String)workflow.getName()).toLowerCase();
            String nameTranslation = ConfluenceActionSupport.getTextStatic((String)("workflow.picker.name." + workflowName));
            String descriptionTranslation = ConfluenceActionSupport.getTextStatic((String)("workflow.picker.description." + workflowName));
            RestWorkflowTranslation restWorkflowTranslation = new RestWorkflowTranslation(restWorkflow, nameTranslation, descriptionTranslation);
            return (T)restWorkflowTranslation;
        }
        return (T)restWorkflow;
    }

    protected Response handleException(Exception e) {
        log.error("Exception caught during mapping process", (Throwable)e);
        JSONObject error = new JSONObject();
        error.put("status", Response.Status.BAD_REQUEST.getStatusCode());
        error.put("message", e.getMessage());
        if (e.getCause() != null) {
            error.put("cause", e.getCause().getMessage());
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error.toString()).type("application/json").build();
    }

    protected void moveReadAckMacroOutsideState(com.comalatech.workflow.model.Workflow workflow) {
        if (workflow instanceof Workflow) {
            ((Workflow)workflow).moveReadAckMacroOutOfState();
        }
    }

    public abstract class RestPageCommand
    extends RestCommand {
        private long contentId;

        public RestPageCommand(long contentId) {
            this.contentId = contentId;
        }

        @Override
        public Object getValidationTarget() {
            return AbstractRestResource.this.pageManager.getById(this.contentId);
        }
    }

    public abstract class RestSpaceCommand
    extends RestCommand {
        private String spaceKey;

        public RestSpaceCommand(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        @Override
        public Object getValidationTarget() {
            return AbstractRestResource.this.spaceManager.getSpace(this.spaceKey);
        }
    }

    public abstract class RestCommand {
        protected boolean hasAnnotation(Class clazz) {
            return null != this.getClass().getEnclosingClass().getAnnotation(clazz) || null != this.getClass().getEnclosingMethod().getAnnotation(clazz);
        }

        protected PermissionRequired getAnnotationIfExists(Method method) {
            PermissionRequired annotation = method.getAnnotation(PermissionRequired.class);
            if (annotation != null) {
                return annotation;
            }
            return method.getDeclaringClass().getDeclaredAnnotation(PermissionRequired.class);
        }

        protected RestCommand validate() throws ApplicationPermissionException {
            boolean allowed = true;
            boolean skip = false;
            if (this.hasAnnotation(WorkflowsAppRequired.class)) {
                skip = allowed = AbstractRestResource.this.workflowsFeatureManager.isWorkflowsApp();
            }
            if (!skip && this.hasAnnotation(WorkflowsLiteAppRequired.class)) {
                allowed = AbstractRestResource.this.workflowsFeatureManager.isWorkflowsLiteApp();
            }
            if (!allowed) {
                throw new ApplicationPermissionException(AbstractRestResource.APPLICATION_PERMISSION_ERROR + this.getClass().getEnclosingClass().getName() + ":" + this.getClass().getEnclosingMethod().getName());
            }
            PermissionRequired annotation = this.getAnnotationIfExists(this.getClass().getEnclosingMethod());
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            Object target = this.getValidationTarget();
            if (annotation != null) {
                for (String permission : annotation.value()) {
                    if (AbstractRestResource.this.permissionManager.hasPermission((User)user, Permission.forName((String)permission), target)) continue;
                    throw new ApplicationPermissionException(user.getName() + " has no " + permission + " permission over " + target);
                }
            }
            return this;
        }

        public Object getValidationTarget() {
            return PermissionManager.TARGET_APPLICATION;
        }

        public final Response execute() {
            try {
                return this.validate().doExecute();
            }
            catch (ApplicationPermissionException e) {
                if (e.getMessage().contains(AbstractRestResource.APPLICATION_PERMISSION_ERROR)) {
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.NOT_FOUND.getStatusCode());
                    error.put("message", ConfluenceActionSupport.getTextStatic((String)"workflows.workflow.error", (Object[])new String[]{e.getMessage()}));
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error.toString()).type("application/json").build();
                }
                JSONObject error = new JSONObject();
                error.put("status", Response.Status.FORBIDDEN.getStatusCode());
                error.put("message", ConfluenceActionSupport.getTextStatic((String)"workflows.workflow.error", (Object[])new String[]{e.getMessage()}));
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)error.toString()).type("application/json").build();
            }
            catch (MarkupValidationException ex) {
                JSONObject error = new JSONObject();
                error.put("status", Response.Status.BAD_REQUEST.getStatusCode());
                error.put("message", ex.getMessage());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error.toString()).type("application/json").build();
            }
            catch (WorkflowException e) {
                JSONObject error = new JSONObject();
                error.put("status", Response.Status.BAD_REQUEST.getStatusCode());
                error.put("message", ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.workflow.error", (Object[])new String[]{e.getMessage()}));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error.toString()).type("application/json").build();
            }
            catch (Exception e) {
                e.printStackTrace();
                JSONObject error = new JSONObject();
                error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                error.put("message", e.getMessage() != null ? e.getMessage() : "Internal server error");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
            }
        }

        public abstract Response doExecute() throws WorkflowException, MarkupValidationException;
    }
}

