/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.expander.content;

import com.comalatech.confluence.adhocworkflows.rest.model.Approval;
import com.comalatech.confluence.adhocworkflows.rest.model.Approver;
import com.comalatech.confluence.workflow.rest.expander.content.AbstractWorkflowActionExpander;
import com.comalatech.confluence.workflow.rest.model.ContentApproval;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowRequest;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class ApprovalsExpander
extends AbstractWorkflowActionExpander {
    public static final String EXPANDER = "approvals";

    public ApprovalsExpander() {
        super(EXPANDER);
    }

    @Override
    public void expand(ContentWorkflowResponse response, ContentWorkflowRequest request) {
        ArrayList<ContentApproval> contentApprovals = new ArrayList<ContentApproval>();
        if (request.getWorkflowAction().getApprovals() != null) {
            for (Approval approval : request.getWorkflowAction().getApprovals()) {
                ContentApproval contentApprovalStatus = new ContentApproval(approval.getName(), this.makeShortName(approval.getShortName()), approval.getMinimumRequiredApprovers(), approval.isRolesEnabled());
                contentApprovalStatus.filterUsers = Arrays.asList(StringUtils.split((String)approval.getFilterUsers(), (String)","));
                contentApprovalStatus.filterGroups = Arrays.asList(StringUtils.split((String)approval.getFilterGroups(), (String)","));
                contentApprovalStatus.filterExcludedUsers = Arrays.asList(StringUtils.split((String)approval.getFilterExcludedUsers(), (String)","));
                contentApprovalStatus.approveLabel = approval.getApproveLabel();
                contentApprovalStatus.rejectLabel = approval.getRejectLabel();
                contentApprovalStatus.isOneApproverOnly = approval.isOneApproverOnly();
                for (Approver approver : approval.getApprovers()) {
                    ContentApproval.Approver contentApproverStatus = new ContentApproval.Approver(approver.getUser(), approver.isApproved(), approver.isRejected(), approver.getComment());
                    contentApprovalStatus.approvers.add(contentApproverStatus);
                }
                contentApprovals.add(contentApprovalStatus);
            }
        }
        response.approvals = contentApprovals;
    }

    protected String makeShortName(String name) {
        StringTokenizer stok = new StringTokenizer(name, " ");
        stok.nextElement();
        StringBuilder shortName = new StringBuilder();
        shortName.append(name.charAt(0));
        if (stok.hasMoreElements()) {
            shortName.append(stok.nextToken().charAt(0));
        } else if (name.length() > 0) {
            shortName.append(name.charAt(1));
        }
        return shortName.toString().toUpperCase();
    }
}

