/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.ipc.WorkflowReporterMacroDelegate;
import com.comalatech.confluence.util.OsgiUtils;
import com.comalatech.confluence.workflowreports.WorkflowReportManager;
import com.comalatech.workflow.ContentReportingService;
import com.servicerocket.confluence.randombits.support.confluence.MacroInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowReporterMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(WorkflowReporterMacro.class);
    public static final String ABSTRACT_REPORTER_MACRO_CLASS = "net.customware.reporting.confluence.macro.AbstractReporterMacro";
    public static final String REPORTING_MACRO_ASSISTANT_CLASS = "net.customware.reporting.confluence.ReportingMacroAssistant";
    public static final String LICENSE_CHECKER_CLASS = "net.customware.reporting.confluence.license.LicenseChecker";
    public static final String MACRO_INFO_66_CLASS = "org.randombits.confluence.support.MacroInfo";
    public static final String WORKFLOW_REPORTER_MACRO_DELEGATE_66_CLASS = "com.comalatech.confluence.workflow.compatibility.reporting.WorkflowReporterMacroDelegate66";
    protected final ContentReportingService contentReportingService;
    private final WorkflowReportManager workflowReportManager;

    public WorkflowReporterMacro(ContentReportingService contentReportingService, WorkflowReportManager workflowReportManager) {
        this.contentReportingService = contentReportingService;
        this.workflowReportManager = workflowReportManager;
    }

    public String execute(Map<String, String> params, String body, final ConversionContext conversionContext) {
        Class<?> licenseCheckerClass;
        Class<?> reportingMacroAssistantClass;
        Class<?> abstractReporterMacroClass;
        ClassLoader cl;
        try {
            cl = ((Object)((Object)this)).getClass().getClassLoader();
            abstractReporterMacroClass = cl.loadClass(ABSTRACT_REPORTER_MACRO_CLASS);
            reportingMacroAssistantClass = cl.loadClass(REPORTING_MACRO_ASSISTANT_CLASS);
            licenseCheckerClass = cl.loadClass(LICENSE_CHECKER_CLASS);
        }
        catch (ClassNotFoundException cnf) {
            return ConfluenceActionSupport.getTextStatic((String)"com.comalatech.macro.reporting.error.reporting-plugin-not-found");
        }
        Object reportingMacroAssistant = OsgiUtils.getService(reportingMacroAssistantClass);
        Object licenseChecker = OsgiUtils.getService(licenseCheckerClass);
        if (reportingMacroAssistant == null || licenseChecker == null) {
            return ConfluenceActionSupport.getTextStatic((String)"com.comalatech.macro.reporting.error.nullServices");
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(cl);
        enhancer.setSuperclass(abstractReporterMacroClass);
        MethodInterceptor methodInterceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (method.getDeclaringClass() != Object.class && "createQuery".equals(method.getName())) {
                    MacroInfo macroInfo = (MacroInfo)args[0];
                    try {
                        Class<?> workflowReporterMacroDelegate66Class = cl.loadClass(WorkflowReporterMacro.WORKFLOW_REPORTER_MACRO_DELEGATE_66_CLASS);
                        Constructor<?> workflowReporterMacroDelegate66Constructor = workflowReporterMacroDelegate66Class.getConstructor(Object.class);
                        Object workflowReporterMacroDelegate66Instance = workflowReporterMacroDelegate66Constructor.newInstance(WorkflowReporterMacro.this.workflowReportManager);
                        Class<?> macroInfo66Class = cl.loadClass(WorkflowReporterMacro.MACRO_INFO_66_CLASS);
                        Constructor<?> macroInfo66Constructor = macroInfo66Class.getConstructor(Map.class, String.class, PageContext.class);
                        Map params = macroInfo.getMacroParamsMap();
                        String macroBody = macroInfo.getMacroBody();
                        PageContext pageContext = conversionContext.getPageContext();
                        Object macroInfo66Instance = macroInfo66Constructor.newInstance(params, macroBody, pageContext);
                        return workflowReporterMacroDelegate66Class.getMethod("createQuery", macroInfo66Class).invoke(workflowReporterMacroDelegate66Instance, macroInfo66Instance);
                    }
                    catch (NoClassDefFoundError ncdf) {
                        return new WorkflowReporterMacroDelegate(WorkflowReporterMacro.this.contentReportingService).createQuery(macroInfo);
                    }
                }
                return proxy.invokeSuper(obj, args);
            }
        };
        try {
            enhancer.setCallback((Callback)methodInterceptor);
            Macro macro = (Macro)enhancer.create(new Class[]{reportingMacroAssistantClass, licenseCheckerClass}, new Object[]{reportingMacroAssistant, licenseChecker});
            Field field = macro.getClass().getSuperclass().getDeclaredField("valueType");
            field.setAccessible(true);
            field.set(macro, AbstractPage.class);
            return macro.execute(params, body, conversionContext);
        }
        catch (Exception meex) {
            String i18nError = ConfluenceActionSupport.getTextStatic((String)"com.comalatech.macro.reporting.error.general-error");
            log.error(i18nError, (Throwable)meex);
            return i18nError;
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map map, String body, RenderContext rc) throws MacroException {
        return this.execute((Map<String, String>)map, body, (ConversionContext)new DefaultConversionContext(rc));
    }
}

