/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.usecases;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalsMapper;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivityApprovals;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import java.util.ArrayList;
import java.util.List;

public class GenerateDocumentActivityApprovalUseCase
implements GenerateDocumentActivityApprovals {
    private final ApprovalsMapper approvalsMapper;

    public GenerateDocumentActivityApprovalUseCase(UserAccessor userAccessor, PageManager pageManager, WorkflowUserAccessor workflowUserAccessor) {
        this.approvalsMapper = new ApprovalsMapper(pageManager, new ActorUtils(userAccessor, workflowUserAccessor));
    }

    @Override
    public List<Activity> generate(PageState state, List<ApprovalCheck> approvalChecks) throws Exception {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        if (state != null && approvalChecks != null && !approvalChecks.isEmpty()) {
            for (ApprovalCheck approvalCheck : approvalChecks) {
                activities.addAll(this.approvalsMapper.buildApprovalActivities(state, approvalCheck));
            }
        }
        return activities;
    }
}

