/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.tasks;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheck;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheckStatus;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.upgrade.support.commands.UpgradeLog;
import com.comalatech.confluence.documentActivity.upgrade.support.model.UpgradeLogData;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivity;
import com.comalatech.confluence.documentActivity.usecases.contracts.ValidateDocumentActivity;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.analytics.UpgradeStatsGatherer;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceUpgradeTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(SpaceUpgradeTask.class);
    private final Space space;
    private final PreCheck preCheck;
    private final List<PageActivityRecord> pageActivityRecords;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final ValidateDocumentActivity validateDocumentActivity;
    private final GenerateDocumentActivity generateDocumentActivity;
    private final PageManager pageManager;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final UpgradeStatsGatherer upgradeStatsGatherer;
    private final boolean upgrade;
    private final UpgradeLog upgradeLog;
    public static final String NAME = ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.global.workflows.upgrade.checks.checkup.task");

    public SpaceUpgradeTask(Space space, PreCheck preCheck, List<PageActivityRecord> pageActivityRecords, DocumentActivityUpgradeService documentActivityUpgradeService, ValidateDocumentActivity validateDocumentActivity, GenerateDocumentActivity generateDocumentActivity, PageManager pageManager, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, UpgradeStatsGatherer upgradeStatsGatherer, boolean upgrade) {
        this.space = space;
        this.preCheck = preCheck;
        this.upgrade = upgrade;
        this.pageActivityRecords = pageActivityRecords;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.validateDocumentActivity = validateDocumentActivity;
        this.generateDocumentActivity = generateDocumentActivity;
        this.pageManager = pageManager;
        this.readWriteTransactionService = readWriteTransactionService;
        this.upgradeStatsGatherer = upgradeStatsGatherer;
        this.upgradeLog = new UpgradeLog(templateFileLayoutHelper);
    }

    public String getName() {
        return NAME;
    }

    protected void runInternal() {
        Instant startedAt = Instant.now();
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList pagesWithErrors = new ArrayList();
        AtomicBoolean cancelledByUser = new AtomicBoolean(false);
        try {
            SupportPackageFile.deleteSpaceBaseFolder(this.space.getKey());
            if (this.isPreCheckTaskReadyToStart()) {
                if (this.pageActivityRecords != null && !this.pageActivityRecords.isEmpty()) {
                    log.debug("Upgrade task started for space " + this.space.getKey() + ", containing " + this.pageActivityRecords.size() + " pages with activity");
                    this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                        long totalDocActEntries = 0L;
                        for (int i = 0; i < this.pageActivityRecords.size(); ++i) {
                            if (this.hasBeenCancelledByUser(this.space)) {
                                cancelledByUser.set(true);
                                throw new RuntimeException("The pre-check task for the space " + this.space.getKey() + " has been cancelled by the user");
                            }
                            PageActivityRecord page = this.pageActivityRecords.get(i);
                            Long pageId = page.getPageId();
                            boolean successfulValidation = false;
                            AbstractPage content = this.pageManager.getAbstractPage(pageId.longValue());
                            if (content != null) {
                                log.debug(MessageFormat.format("Page {0} ({1}) processing...", content.getTitle(), content.getId()));
                                try {
                                    List<Activity> activities = this.generateDocumentActivity.generate(content);
                                    successfulValidation = this.validateDocumentActivity.validate(content, activities, true, SupportPackageFile.getDataBasePath(this.space.getKey(), content.getId()));
                                    if (successfulValidation && !this.upgrade) {
                                        totalDocActEntries += (long)activities.size();
                                    }
                                }
                                catch (Exception e) {
                                    this.handleError(messages, MessageFormat.format("Content of id {0} failed during the validation", pageId), e);
                                }
                            } else {
                                this.handleError(messages, MessageFormat.format("Content of id {0} does not exist", pageId), null);
                            }
                            this.progress.setPercentage(i, this.pageActivityRecords.size());
                            if (!successfulValidation) {
                                pagesWithErrors.add(pageId);
                            }
                            log.debug(MessageFormat.format("Page {0} process finished successfully: {1}.", pageId, successfulValidation));
                        }
                        this.upgradeStatsGatherer.saveTotalDocActivityEntriesAsStatField(this.space.getKey(), totalDocActEntries);
                        if (!pagesWithErrors.isEmpty()) {
                            this.handleError(messages, MessageFormat.format("Space {0} Upgrade task failed for these pages: {1} ..., forcing rollback.", this.space.getKey(), pagesWithErrors), null);
                            throw new RuntimeException();
                        }
                        this.preCheck.setStatus(PreCheckStatus.SUCCESS);
                        return null;
                    });
                } else {
                    log.debug("There is no page with activity for the space:" + this.space.getKey());
                    this.preCheck.setStatus(PreCheckStatus.SUCCESS);
                }
            } else {
                this.preCheck.setStatus(PreCheckStatus.FAIL);
                this.handleError(messages, MessageFormat.format("Error starting the long running task for the space {0}", this.space.getKey()), null);
            }
        }
        catch (Exception e) {
            this.handleError(messages, "Error during the activities upgrade.", e);
            if (cancelledByUser.get()) {
                this.preCheck.setStatus(PreCheckStatus.CANCEL);
            }
            this.preCheck.setNumErrors(pagesWithErrors.size());
            this.preCheck.setStatus(PreCheckStatus.FAIL);
        }
        switch (this.preCheck.getStatus()) {
            case FAIL: {
                try {
                    if (!messages.isEmpty()) {
                        this.upgradeLog.generateSupportFile(UpgradeLogData.builder().messages(messages).build(), SupportPackageFile.generateSpaceBaseFolder(this.space.getKey()));
                    }
                }
                catch (IOException e) {
                    log.error("Error generating the space support zip.");
                }
                this.progress.setCompletedSuccessfully(false);
                this.preCheck.setDuration(TimerUtils.getDuration(startedAt));
                break;
            }
            case SUCCESS: {
                this.progress.setCompletedSuccessfully(true);
                this.preCheck.setDuration(TimerUtils.getDuration(startedAt));
                break;
            }
            case CANCEL: {
                this.progress.setCompletedSuccessfully(false);
                this.cancelPreCheckTaskProperties(this.preCheck);
            }
        }
        this.progress.setPercentage(100);
        this.documentActivityUpgradeService.saveSpacePreCheck(this.space, this.preCheck);
        log.debug("Upgrade task finished for space " + this.space.getKey());
    }

    private void handleError(List<String> messages, String message, Exception ex) {
        messages.add(message);
        if (ex != null) {
            messages.add(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        if (ex != null) {
            log.error(message, (Throwable)ex);
        } else {
            log.error(message);
        }
    }

    private boolean hasBeenCancelledByUser(Space space) {
        PreCheck preCheck = this.documentActivityUpgradeService.getSpacePreCheck(space);
        return preCheck != null && PreCheckStatus.CANCEL.equals((Object)preCheck.getStatus());
    }

    private void cancelPreCheckTaskProperties(PreCheck preCheck) {
        preCheck.setStatus(PreCheckStatus.CANCEL);
        preCheck.setStartedAt(null);
        preCheck.setDuration(null);
        preCheck.setSupport(null);
        preCheck.setNumErrors(null);
        preCheck.setProgress(0);
    }

    private boolean isPreCheckTaskReadyToStart() throws InterruptedException {
        PreCheck preCheckStored = this.documentActivityUpgradeService.getSpacePreCheck(this.space);
        DateTime timeLimit = DateTime.now().plusSeconds(180);
        while (!PreCheckStatus.IN_PROGRESS.equals((Object)preCheckStored.getStatus()) && DateTime.now().getMillis() <= timeLimit.getMillis()) {
            preCheckStored = this.documentActivityUpgradeService.getSpacePreCheck(this.space);
            Thread.sleep(2000L);
        }
        if (!PreCheckStatus.IN_PROGRESS.equals((Object)preCheckStored.getStatus())) {
            return false;
        }
        this.preCheck.setStartedAt(preCheckStored.getStartedAt());
        return true;
    }
}

