/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.DateRangeFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.FilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.MomentFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.StateFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.TargetFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.TypesFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.UsersFilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class FiltersProcessor {
    private final List<FilterBuilder> filterBuilders;
    private final FilterBuilder usersFilterBuilder = new UsersFilterBuilder();

    public FiltersProcessor() {
        this.filterBuilders = Arrays.asList(new StateFilterBuilder(), new TargetFilterBuilder(), new MomentFilterBuilder(), new DateRangeFilterBuilder(), new TypesFilterBuilder(), this.usersFilterBuilder);
    }

    public void addFiltersToQuery(Query query, DocumentActivityQuery criteria) {
        List<Query> filters = this.filterBuilders.stream().filter(filterBuilder -> filterBuilder.shouldApply(criteria)).map(filterBuilder -> filterBuilder.build(criteria)).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList whereClauses = new ArrayList();
        ArrayList values = new ArrayList();
        filters.forEach(queryFilter -> {
            whereClauses.add(queryFilter.getWhereClause());
            Collections.addAll(values, queryFilter.getWhereParams());
        });
        String whereClause = String.join((CharSequence)" AND ", whereClauses);
        if (whereClause.length() > 0) {
            query.where(whereClause, values.toArray());
        }
    }

    public boolean needsDetailQuery(DocumentActivityQuery query) {
        return ((UsersFilterBuilder)this.usersFilterBuilder).shouldApplyToParticipants(query) || ((UsersFilterBuilder)this.usersFilterBuilder).shouldApplyToUsers(query);
    }
}

