/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ValidatePageActivity;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ValidateActivityUseCase
implements ValidatePageActivity {
    private static final Logger log = LoggerFactory.getLogger(ValidateActivityUseCase.class);
    private final ActivityManager activityManager;
    private final PageActivityCsvService pageActivityCsvService;
    private final PageActivityCsvService docActivityCSVService;

    public ValidateActivityUseCase(ActivityManager activityManager, @Qualifier(value="pageActivityCsvService") PageActivityCsvService pageActivityCsvService, @Qualifier(value="docActivityCsvService") PageActivityCsvService docActivityCSVService) {
        this.activityManager = activityManager;
        this.pageActivityCsvService = pageActivityCsvService;
        this.docActivityCSVService = docActivityCSVService;
    }

    @Override
    public boolean validateActivity(AbstractPage page, List<Activity> activities, boolean onlyCurrentActivity) {
        boolean areSameEntries;
        ActivityReportOptions exportOptions = new ActivityReportOptions(false, false, false, false, false, false, Integer.MAX_VALUE);
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReportForMigration(page, exportOptions);
        String currentReportEntries = onlyCurrentActivity ? this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries.size() > 0 ? activityReportEntries.subList(0, 1) : activityReportEntries, page) : this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries, page);
        String newReportModelEntries = this.docActivityCSVService.getPageActivityFileContent(activities, page);
        String initialisationOverride = this.getStateInitialisationOverrideText();
        String adminOverride = this.getStateAdminOverrideText();
        if (currentReportEntries.contains(initialisationOverride)) {
            currentReportEntries = currentReportEntries.replace(initialisationOverride, "");
        }
        if (currentReportEntries.contains(adminOverride)) {
            currentReportEntries = currentReportEntries.replace(adminOverride, "");
        }
        if (!(areSameEntries = Objects.equals(currentReportEntries, newReportModelEntries))) {
            String diff = StringUtils.difference((String)currentReportEntries, (String)newReportModelEntries);
            log.info("Page " + page.getTitle() + " has differences between current report entries and new activity domain entries: " + diff);
            int index = StringUtils.indexOfDifference((CharSequence)currentReportEntries, (CharSequence)newReportModelEntries);
            if (currentReportEntries != null) {
                log.info("Both reports have this content in common: " + currentReportEntries.substring(0, index));
            }
        }
        return areSameEntries;
    }

    private String getStateInitialisationOverrideText() {
        return " (" + ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflows.stateChangeReason.spaceInitialise") + ")";
    }

    private String getStateAdminOverrideText() {
        return " (" + ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflows.stateChangeReason.adminOverride") + ")";
    }
}

