/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.assignment;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.GroupManager;
import com.comalatech.confluence.assignment.AssignmentManager;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.opensymphony.util.TextUtils;
import java.util.Date;

public class DefaultAssignmentManager
implements AssignmentManager {
    private final UserAccessor userAccessor;
    private final GroupManager groupManager;

    public DefaultAssignmentManager(UserAccessor userAccessor, GroupManager groupManager) {
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
    }

    @Override
    public Assignment createAssignment(String assignee, String groupsList, Date dueDate, String comment) throws WorkflowException {
        boolean assigned = false;
        if (TextUtils.stringSet((String)assignee)) {
            if (this.userAccessor.getUserByName(assignee) == null) {
                throw new WorkflowUserException("comalatech.awp.tasks.error.user-name", assignee);
            }
            assigned = true;
        }
        if (TextUtils.stringSet((String)groupsList)) {
            for (String groupName : MiscUtils.splitAndTrim(groupsList)) {
                try {
                    if (this.groupManager.getGroup(groupName) == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw new WorkflowUserException("comalatech.awp.tasks.error.group-name", groupName);
                }
                assigned = true;
            }
            if (!assigned) {
                throw new WorkflowUserException("comalatech.awp.tasks.error.user-name", assignee);
            }
        }
        Assignment assignment = new Assignment(AuthenticatedUserThreadLocal.getUsername(), new Date(), assignee, null, groupsList, dueDate);
        assignment.setComment(comment);
        return assignment;
    }
}

