/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhocworkflows.rest.AbstractAdhocResources;
import com.comalatech.confluence.adhocworkflows.rest.AbstractRestResources;
import com.comalatech.confluence.adhocworkflows.rest.model.FormRequest;
import com.comalatech.confluence.adhocworkflows.rest.model.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.EditPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@WorkflowsAppRequired
@Path(value="/forms")
public class FormsResources
extends AbstractAdhocResources {
    public FormsResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user/{userName}")
    public Response getUser(@PathParam(value="userName") String userName) {
        User user = this.userSearchManager.makeUser(userName);
        if (user != null) {
            return Response.ok((Object)user).build();
        }
        return Response.notModified().build();
    }

    @EditPagePermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/submit")
    public Response submitForm(@PathParam(value="pageId") long pageId, final FormRequest formRequest) {
        class SubmitFormCommand
        extends AbstractRestResources.WorkflowCommand {
            SubmitFormCommand() {
            }

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                for (FormRequest.Field field : formRequest.getFields()) {
                    FormsResources.this.workflowHandler.setParameter((ContentEntityObject)page, field.getId(), field.getValue());
                }
                return FormsResources.this.getStatus(page, false);
            }
        }
        return new SubmitFormCommand().execute(pageId);
    }
}

