/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.comalatech.confluence.adhoc.command.AbstractAdhocWorkflowCommand;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.opensymphony.util.TextUtils;

@ReadOnlyAccessBlocked
public class MoveTaskCommand
extends AbstractAdhocWorkflowCommand {
    private String fromState;
    private String toState;
    private int position;

    @Override
    public void doWithWorkflow(Workflow workflow) throws WorkflowException {
        State from = workflow.getStatesContainer().getState(this.fromState);
        State to = workflow.getStatesContainer().getState(this.toState);
        Task task = from.getTask(this.taskName);
        from.getTasks().remove(task);
        if (this.position >= to.getTasks().size()) {
            to.addTask(task);
        } else {
            to.getTasks().add(this.position, task);
        }
    }

    @Override
    public void validateWorkflow(ServiceCommandValidator validator, Workflow workflow) {
        if (!TextUtils.stringSet((String)this.fromState) || !TextUtils.stringSet((String)this.toState)) {
            validator.addValidationError("need to set from and to state", new Object[0]);
        } else if (!TextUtils.stringSet((String)this.taskName)) {
            validator.addValidationError("task name not set", new Object[0]);
        } else if (workflow.getStatesContainer().getState(this.fromState) == null) {
            validator.addValidationError("invalid state name " + this.fromState, new Object[0]);
        } else if (workflow.getStatesContainer().getState(this.toState) == null) {
            validator.addValidationError("invalid state name " + this.toState, new Object[0]);
        } else if (workflow.getStatesContainer().getState(this.fromState).getTask(this.taskName) == null) {
            validator.addValidationError("invalid task name " + this.taskName, new Object[0]);
        }
    }

    @Override
    public boolean requiresExistingState() {
        return false;
    }

    @Override
    public boolean requiresExistingTask() {
        return false;
    }

    public void setFromState(String fromState) {
        this.fromState = this.unscapeQuotes(fromState);
    }

    public void setToState(String toState) {
        this.toState = this.unscapeQuotes(toState);
    }

    public void setPosition(int position) {
        this.position = position;
    }
}

