/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.tracker.converter;

import com.atlassian.migration.app.ConfluenceSpaceContainer;
import com.atlassian.migration.app.Container;
import com.atlassian.migration.app.JiraProjectContainer;
import com.atlassian.migration.app.SiteContainer;
import com.atlassian.migration.app.tracker.MigrationDetails;
import com.atlassian.migration.app.tracker.MigrationDetailsV1;
import com.atlassian.migration.app.tracker.converter.SiteSelectionConverter;
import java.util.Collection;
import java.util.stream.Collectors;

public class MigrationDetailsConverter {
    public static MigrationDetails convert(com.atlassian.migration.app.MigrationDetails source) {
        return new MigrationDetails(source.getMigrationId(), source.getMigrationScopeId(), source.getName(), source.getCreatedAt(), source.getCreator(), source.getJiraClientKey(), source.getConfluenceClientKey(), source.getCloudUrl(), MigrationDetailsConverter.convert(source.getContainers()));
    }

    public static MigrationDetailsV1 convert(com.atlassian.migration.app.MigrationDetailsV1 source) {
        return new MigrationDetailsV1(source.getMigrationId(), source.getMigrationScopeId(), source.getName(), source.getCreatedAt(), source.getJiraClientKey(), source.getConfluenceClientKey(), source.getCloudUrl());
    }

    private static Collection<com.atlassian.migration.app.tracker.container.Container> convert(Collection<Container> containers) {
        if (containers == null) {
            return null;
        }
        return containers.stream().map(it -> MigrationDetailsConverter.convert(it)).collect(Collectors.toSet());
    }

    private static com.atlassian.migration.app.tracker.container.Container convert(Container source) {
        if (source == null) {
            return null;
        }
        if (source instanceof ConfluenceSpaceContainer) {
            return new com.atlassian.migration.app.tracker.container.ConfluenceSpaceContainer(((ConfluenceSpaceContainer)source).getKeys());
        }
        if (source instanceof JiraProjectContainer) {
            return new com.atlassian.migration.app.tracker.container.JiraProjectContainer(((JiraProjectContainer)source).getKeys());
        }
        if (source instanceof SiteContainer) {
            return new com.atlassian.migration.app.tracker.container.SiteContainer(SiteSelectionConverter.convert(((SiteContainer)source).getSelections()));
        }
        throw new IllegalArgumentException("Unknown container type: " + source.getClass());
    }
}

