/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.tracker;

import com.atlassian.migration.app.AppCloudMigrationGateway;
import com.atlassian.migration.app.AppCloudMigrationListener;
import com.atlassian.migration.app.BaseAppCloudMigrationListener;
import com.atlassian.migration.app.tracker.AbstractCloudMigrationListener;
import com.atlassian.migration.app.tracker.BoundJiraListenerImplV1;
import com.atlassian.migration.app.tracker.BoundListenerImpl;
import com.atlassian.migration.app.tracker.BoundListenerImplV1;
import com.atlassian.migration.app.tracker.BoundPaginatedContainers;
import com.atlassian.migration.app.tracker.BoundPaginatedMapping;
import com.atlassian.migration.app.tracker.CloudMigrationListener;
import com.atlassian.migration.app.tracker.CloudMigrationListenerV1;
import com.atlassian.migration.app.tracker.JiraCloudMigrationListenerV1;
import com.atlassian.migration.app.tracker.PaginatedContainers;
import com.atlassian.migration.app.tracker.PaginatedMapping;
import com.atlassian.migration.app.tracker.container.ContainerType;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BoundCloudMigrationGateway {
    private final AppCloudMigrationGateway cloudMigrationRegistrar;
    private final Map<AbstractCloudMigrationListener, BoundListenerImpl> listenerMap = new HashMap<AbstractCloudMigrationListener, BoundListenerImpl>();
    private final Map<AbstractCloudMigrationListener, BoundListenerImplV1> listenerMapV1 = new HashMap<AbstractCloudMigrationListener, BoundListenerImplV1>();

    public BoundCloudMigrationGateway(Object appCloudMigrationGateway) {
        this.cloudMigrationRegistrar = (AppCloudMigrationGateway)appCloudMigrationGateway;
    }

    public void registerListener(AbstractCloudMigrationListener it) {
        if (it instanceof JiraCloudMigrationListenerV1) {
            BoundJiraListenerImplV1 boundJiraListenerImplV1 = new BoundJiraListenerImplV1((JiraCloudMigrationListenerV1)it);
            this.listenerMapV1.put(it, boundJiraListenerImplV1);
            this.cloudMigrationRegistrar.registerListener((BaseAppCloudMigrationListener)boundJiraListenerImplV1);
        } else if (it instanceof CloudMigrationListenerV1) {
            BoundListenerImplV1 internalCloudMigrationListener = new BoundListenerImplV1((CloudMigrationListenerV1)it);
            this.listenerMapV1.put(it, internalCloudMigrationListener);
            this.cloudMigrationRegistrar.registerListener((BaseAppCloudMigrationListener)internalCloudMigrationListener);
        } else {
            BoundListenerImpl internalCloudMigrationListener = new BoundListenerImpl((CloudMigrationListener)it);
            this.listenerMap.put(it, internalCloudMigrationListener);
            this.cloudMigrationRegistrar.registerListener((AppCloudMigrationListener)internalCloudMigrationListener);
        }
    }

    public void deregisterListener(AbstractCloudMigrationListener it) {
        if (it instanceof CloudMigrationListenerV1) {
            this.cloudMigrationRegistrar.deregisterListener((BaseAppCloudMigrationListener)this.listenerMapV1.get(it));
        } else {
            this.cloudMigrationRegistrar.deregisterListener((AppCloudMigrationListener)this.listenerMap.get(it));
        }
    }

    public OutputStream createAppData(String transferId) {
        return this.cloudMigrationRegistrar.createAppData(transferId);
    }

    public OutputStream createAppData(String transferId, String label) {
        return this.cloudMigrationRegistrar.createAppData(transferId, label);
    }

    public Map<String, Object> getCloudFeedback(String transferId) {
        return this.cloudMigrationRegistrar.getCloudFeedback(transferId);
    }

    public PaginatedMapping getPaginatedMapping(String transferId, String namespace, int pageSize) {
        return new BoundPaginatedMapping(this.cloudMigrationRegistrar.getPaginatedMapping(transferId, namespace, pageSize));
    }

    public PaginatedContainers getPaginatedContainers(String transferId, ContainerType containerType, int pageSize) {
        return new BoundPaginatedContainers(this.cloudMigrationRegistrar.getPaginatedContainers(transferId, com.atlassian.migration.app.ContainerType.valueOf((String)containerType.name()), pageSize));
    }

    public Map<String, String> getMappingById(String transferId, String namespace, Set<String> ids) {
        return this.cloudMigrationRegistrar.getMappingById(transferId, namespace, ids);
    }
}

