/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils.enums;

import com.atlassian.confluence.pages.AbstractPage;

public enum ConfluenceContentType {
    PAGE("page"),
    BLOGPOST("blogpost");

    private final String contentTypeName;

    private ConfluenceContentType(String name) {
        this.contentTypeName = name;
    }

    public static ConfluenceContentType getTypeFromAbstractPage(AbstractPage abstractPage) {
        if (ConfluenceContentType.isPage(abstractPage.getType())) {
            return PAGE;
        }
        return BLOGPOST;
    }

    public static boolean isPage(String type) {
        return PAGE.getContentTypeName().equalsIgnoreCase(type);
    }

    public String getContentTypeName() {
        return this.contentTypeName;
    }
}

