/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamInternal;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.remotepublishing.PublishHistoryManager;
import com.comalatech.confluence.remotepublishing.config.converter.RemotePublishingConfigurationConverter;
import com.comalatech.confluence.remotepublishing.credentials.converter.CredentialsConverter;
import com.comalatech.confluence.remotepublishing.model.PublishHistoryInfo;
import com.comalatech.confluence.remotepublishing.model.converter.PublishingHistoryInfoConverter;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BandanaPublishHistoryManager
implements PublishHistoryManager {
    private static final Logger log = LoggerFactory.getLogger(BandanaPublishHistoryManager.class);
    private static final String PUBLISH_HISTORY_BANDANA_KEY_PREFIX = "com.comalatech.confluence.remotepublishing.publishHistory-";
    private final BandanaManager bandanaManager;
    private final ConfluenceXStreamManager confluenceXStreamManager;
    private ConfluenceXStreamInternal xStream;

    public BandanaPublishHistoryManager(@ComponentImport BandanaManager bandanaManager, @ComponentImport ConfluenceXStreamManager confluenceXStreamManager) {
        this.bandanaManager = bandanaManager;
        this.confluenceXStreamManager = confluenceXStreamManager;
        this.registerCustomConverter();
    }

    @Override
    public PublishHistoryInfo getLatestPublishHistoryInfo(AbstractPage localPage, String publishConfiguration) {
        List<PublishHistoryInfo> configurationPublishHistories;
        Map<String, List<PublishHistoryInfo>> publishHistoryMap = this.getBandanaPublishHistoryInfo(localPage);
        if (publishHistoryMap.containsKey(publishConfiguration) && !(configurationPublishHistories = publishHistoryMap.get(publishConfiguration)).isEmpty()) {
            return configurationPublishHistories.get(configurationPublishHistories.size() - 1);
        }
        return null;
    }

    @Override
    public void addPublishHistoryInfo(AbstractPage localPage, String publishConfiguration, PublishHistoryInfo publishHistoryInfo) {
        if (publishHistoryInfo != null && localPage != null) {
            Map<String, List<PublishHistoryInfo>> publishHistoryMap = this.getBandanaPublishHistoryInfo(localPage);
            List<Object> configurationPublishHistories = publishHistoryMap.containsKey(publishConfiguration) ? publishHistoryMap.get(publishConfiguration) : new ArrayList();
            configurationPublishHistories.add(publishHistoryInfo);
            publishHistoryMap.put(publishConfiguration, configurationPublishHistories);
            this.saveBandanaPublishHistoryInfoSpaceConfigs(localPage, publishHistoryMap);
        }
    }

    protected Map<String, List<PublishHistoryInfo>> getBandanaPublishHistoryInfo(AbstractPage localPage) {
        Object xstreamObject;
        String bandanaValue = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(localPage.getSpaceKey()), this.getBandanaKey(localPage));
        Map<String, List<PublishHistoryInfo>> publishHistories = new HashMap<String, List<PublishHistoryInfo>>();
        if (bandanaValue != null && !bandanaValue.isEmpty() && (xstreamObject = this.xStream.fromXML(bandanaValue)) instanceof Map) {
            publishHistories = (Map)xstreamObject;
        }
        return publishHistories;
    }

    protected void saveBandanaPublishHistoryInfoSpaceConfigs(AbstractPage localPage, Map<String, List<PublishHistoryInfo>> publishHistories) {
        String saveData = null;
        if (publishHistories != null) {
            saveData = this.xStream.toXML(publishHistories);
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(localPage.getSpaceKey()), this.getBandanaKey(localPage), (Object)saveData);
    }

    protected String getBandanaKey(AbstractPage page) {
        return PUBLISH_HISTORY_BANDANA_KEY_PREFIX + page.getIdAsString();
    }

    private void registerCustomConverter() {
        this.xStream = (ConfluenceXStreamInternal)this.confluenceXStreamManager.getPluginXStream(this.getClass().getClassLoader());
        this.xStream.allowTypesByWildcard(new String[]{"com.comalatech.confluence.remotepublishing.**"});
        this.xStream.registerConverter((Converter)new CredentialsConverter(), Integer.valueOf(1));
        this.xStream.registerConverter((Converter)new RemotePublishingConfigurationConverter(), Integer.valueOf(1));
        this.xStream.registerConverter((Converter)new PublishingHistoryInfoConverter(), Integer.valueOf(1));
    }
}

