/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.config;

import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseProtocolException;
import com.atlassian.sal.api.net.ResponseTransportException;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.remotepublishing.ApplinkRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RestRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.applink.ConfluenceRemotePublishingAppLinkService;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfigurationManager;
import com.comalatech.confluence.remotepublishing.credentials.models.AppLinkCredentials;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.credentials.models.UserCredentials;
import com.comalatech.confluence.remotepublishing.license.RemotePublishingLicenseManager;
import com.comalatech.confluence.remotepublishing.model.EntityLink;
import com.comalatech.confluence.remotepublishing.utils.enums.DarkFeatureKey;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceConfigurationAction
extends SpaceAdminAction {
    private static final Logger log = LoggerFactory.getLogger(SpaceConfigurationAction.class);
    public static final String APPLINK = "applink";
    public static final String USER_CREDENTIALS = "user";
    private RemotePublishingConfigurationManager remotePublishingConfigurationManager;
    private RestRemotePublishingManager restRemotePublishingManager;
    private ApplinkRemotePublishingManager applinkRemotePublishingManager;
    private ConfluenceRemotePublishingAppLinkService appLinkService;
    private RemotePublishingLicenseManager licenseManager;
    @ComponentImport
    private RequestFactory<?> requestFactory;
    @ComponentImport
    private DarkFeatureManager darkFeatureManager;
    private String configurationName;
    private String configurationUrl;
    private String configurationUser;
    private String configurationPassword;
    private String configurationSpace;
    private String configurationEntityLinkKey;
    private String configurationType = "user";
    private String testConfigName;
    private String testErrorMessage;
    private String editConfigName;

    @ReadOnlyAccessAllowed
    public String viewSpaceConfiguration() {
        return "success";
    }

    public String removeSpaceConfiguration() {
        this.remotePublishingConfigurationManager.removeSpaceConfiguration(this.getSpaceKey(), this.configurationName);
        return "success";
    }

    public String addSpaceConfiguration() throws TypeNotInstalledException {
        if (!this.validateNewConfigurationParameters()) {
            return "input";
        }
        RemotePublishingConfiguration config = RemotePublishingConfiguration.builder().name(this.configurationName).build();
        if (this.isAppLinkConfiguration()) {
            com.atlassian.applinks.api.EntityLink entityLink = this.appLinkService.getEntityLink(this.configurationEntityLinkKey, this.getSpaceKey());
            config.setCredentials(((AppLinkCredentials.AppLinkCredentialsBuilder)((AppLinkCredentials.AppLinkCredentialsBuilder)((AppLinkCredentials.AppLinkCredentialsBuilder)AppLinkCredentials.builder().remoteSpaceKey(entityLink.getKey())).entityLinkName(entityLink.getName())).entityLinkKey(entityLink.getKey())).build());
        } else {
            config.setCredentials(((UserCredentials.UserCredentialsBuilder)((UserCredentials.UserCredentialsBuilder)((Credentials.CredentialsBuilder)((UserCredentials.UserCredentialsBuilder)((UserCredentials.UserCredentialsBuilder)UserCredentials.builder().url(this.configurationUrl)).loginUserName(this.configurationUser)).password(this.configurationPassword)).remoteSpaceKey(this.configurationSpace)).remoteUserName(this.configurationUser)).build());
        }
        try {
            this.remotePublishingConfigurationManager.putSpaceConfiguration(this.getSpaceKey(), config);
            return "success";
        }
        catch (Exception e) {
            log.error(e.getMessage(), e.getCause() != null ? e.getCause() : e);
            this.addFieldError("unexpectedError", e.getMessage());
            return "input";
        }
    }

    @ReadOnlyAccessAllowed
    public String testSpaceConfiguration() {
        this.checkCredentials(this.testConfigName);
        return "success";
    }

    private boolean checkCredentials(String configName) {
        String spaceKey = this.getSpaceKey();
        RemotePublishingConfiguration config = this.remotePublishingConfigurationManager.getSpaceConfiguration(spaceKey, configName);
        if (config != null) {
            try {
                if (this.isAppLinkConfiguration(config)) {
                    this.applinkRemotePublishingManager.checkCredentials(config, spaceKey);
                } else {
                    this.checkUrl(config);
                    this.restRemotePublishingManager.checkCredentials(config, spaceKey);
                }
                return true;
            }
            catch (ResponseProtocolException | ResponseTransportException e) {
                this.testErrorMessage = this.getText("remotepublishing.space.config.test.malformedUrl", new Object[]{config.getUserCredentials().getUrl(), e.getMessage()});
                log.error(this.testErrorMessage, e.getCause() != null ? e.getCause() : e);
            }
            catch (ResponseException e) {
                this.testErrorMessage = this.getText("remotepublishing.space.config.test.urlCannotConnect", new Object[]{config.getUserCredentials().getUrl(), e.getMessage()});
                log.error(this.testErrorMessage, e.getCause() != null ? e.getCause() : e);
            }
            catch (RemotePublishingException e) {
                this.testErrorMessage = e.getMessage();
                log.error(this.testErrorMessage, e.getCause() != null ? e.getCause() : e);
            }
        }
        return false;
    }

    private void checkUrl(RemotePublishingConfiguration config) throws ResponseException {
        Request request = this.requestFactory.createRequest(Request.MethodType.HEAD, config.getUserCredentials().getUrl());
        request.execute(response -> log.info("CheckUrl response {}", (Object)response));
    }

    protected boolean validateNewConfigurationParameters() {
        if (this.isAppLinkConfiguration()) {
            this.validateApplinkCredentialsInputs();
        } else {
            this.validateUserCredentialsInputs();
        }
        return !this.hasActionErrors() && !this.hasFieldErrors();
    }

    private void validateApplinkCredentialsInputs() {
        if (StringUtils.isBlank((CharSequence)this.configurationEntityLinkKey)) {
            this.addFieldError("configurationEntityLinkKey", this.getText("remotepublishing.space.config.applinkname.emptyError"));
        }
    }

    private void validateUserCredentialsInputs() {
        if (StringUtils.isBlank((CharSequence)this.configurationName)) {
            this.addFieldError("configurationName", this.getText("remotepublishing.space.config.name.emptyError"));
        } else {
            this.configurationName = this.configurationName.trim();
            if (this.configurationName.contains(" ")) {
                this.addFieldError("configurationName", this.getText("remotepublishing.space.config.name.containsSpacesError"));
            }
        }
        if (StringUtils.isBlank((CharSequence)this.configurationUrl)) {
            this.addFieldError("configurationUrl", this.getText("remotepublishing.space.config.url.emptyError"));
        }
        if (StringUtils.isBlank((CharSequence)this.configurationUser)) {
            this.addFieldError("configurationUser", this.getText("remotepublishing.space.config.user.emptyError"));
        }
        if (StringUtils.isBlank((CharSequence)this.configurationPassword)) {
            this.addFieldError("configurationPassword", this.getText("remotepublishing.space.config.password.emptyError"));
        }
    }

    public List<RemotePublishingConfiguration> getUserConfigurations() {
        return this.remotePublishingConfigurationManager.getSpaceConfigurations(this.getSpaceKey()).stream().filter(conf -> !conf.isAppLinkCredential()).collect(Collectors.toList());
    }

    public List<RemotePublishingConfiguration> getAppLinkConfigurations() {
        return this.remotePublishingConfigurationManager.getSpaceConfigurations(this.getSpaceKey()).stream().filter(RemotePublishingConfiguration::isAppLinkCredential).collect(Collectors.toList());
    }

    public boolean isActiveApplinkConnectionToSpace(String configName) {
        return this.checkCredentials(configName);
    }

    public List<EntityLink> getEntityLinks() {
        List<com.atlassian.applinks.api.EntityLink> entityLinks = this.appLinkService.getEntityLinks(this.getSpaceKey());
        return entityLinks.stream().map(e -> new EntityLink(e.getName(), e.getKey())).collect(Collectors.toList());
    }

    public boolean isAppLinkDarkFeatureEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers(DarkFeatureKey.APP_LINK.getKey()).orElse(false);
    }

    private boolean isAppLinkConfiguration(RemotePublishingConfiguration config) {
        return this.isAppLinkDarkFeatureEnabled() && config.isAppLinkCredential();
    }

    private boolean isAppLinkConfiguration() {
        return this.configurationType.equals(APPLINK) && this.isAppLinkDarkFeatureEnabled();
    }

    @ParameterSafe
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    @ParameterSafe
    public void setConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
    }

    @ParameterSafe
    public void setConfigurationUser(String configurationUser) {
        this.configurationUser = configurationUser;
    }

    @ParameterSafe
    public void setConfigurationPassword(String configurationPassword) {
        this.configurationPassword = configurationPassword;
    }

    @ParameterSafe
    public void setConfigurationEntityLinkKey(String configurationEntityLinkKey) {
        this.configurationEntityLinkKey = configurationEntityLinkKey;
    }

    @ParameterSafe
    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    @ParameterSafe
    public void setConfigurationSpace(String configurationSpace) {
        this.configurationSpace = configurationSpace;
    }

    @ParameterSafe
    public void setTestConfigName(String testConfigName) {
        this.testConfigName = testConfigName;
    }

    @ParameterSafe
    public void setEditConfigName(String editConfigName) {
        this.editConfigName = editConfigName;
    }

    public RemotePublishingConfigurationManager getRemotePublishingConfigurationManager() {
        return this.remotePublishingConfigurationManager;
    }

    public RestRemotePublishingManager getRestRemotePublishingManager() {
        return this.restRemotePublishingManager;
    }

    public ApplinkRemotePublishingManager getApplinkRemotePublishingManager() {
        return this.applinkRemotePublishingManager;
    }

    public ConfluenceRemotePublishingAppLinkService getAppLinkService() {
        return this.appLinkService;
    }

    public RemotePublishingLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public RequestFactory<?> getRequestFactory() {
        return this.requestFactory;
    }

    public DarkFeatureManager getDarkFeatureManager() {
        return this.darkFeatureManager;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getConfigurationUrl() {
        return this.configurationUrl;
    }

    public String getConfigurationUser() {
        return this.configurationUser;
    }

    public String getConfigurationPassword() {
        return this.configurationPassword;
    }

    public String getConfigurationSpace() {
        return this.configurationSpace;
    }

    public String getConfigurationEntityLinkKey() {
        return this.configurationEntityLinkKey;
    }

    public String getConfigurationType() {
        return this.configurationType;
    }

    public String getTestConfigName() {
        return this.testConfigName;
    }

    public String getTestErrorMessage() {
        return this.testErrorMessage;
    }

    public String getEditConfigName() {
        return this.editConfigName;
    }

    public void setRemotePublishingConfigurationManager(RemotePublishingConfigurationManager remotePublishingConfigurationManager) {
        this.remotePublishingConfigurationManager = remotePublishingConfigurationManager;
    }

    public void setRestRemotePublishingManager(RestRemotePublishingManager restRemotePublishingManager) {
        this.restRemotePublishingManager = restRemotePublishingManager;
    }

    public void setApplinkRemotePublishingManager(ApplinkRemotePublishingManager applinkRemotePublishingManager) {
        this.applinkRemotePublishingManager = applinkRemotePublishingManager;
    }

    public void setAppLinkService(ConfluenceRemotePublishingAppLinkService appLinkService) {
        this.appLinkService = appLinkService;
    }

    public void setLicenseManager(RemotePublishingLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setRequestFactory(RequestFactory<?> requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void setDarkFeatureManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }
}

