/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import com.atlassian.applinks.api.ApplicationLink;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.applink.ConfluenceRemotePublishingAppLinkService;
import com.comalatech.confluence.remotepublishing.confluence.RemotePublisherService;
import com.comalatech.confluence.remotepublishing.credentials.models.AppLinkCredentials;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.utils.ConnectionCommand;
import com.comalatech.confluence.remotepublishing.utils.enums.DarkFeatureKey;
import java.util.List;

public abstract class ApplinkConnectionCommand
extends ConnectionCommand {
    private final ConfluenceRemotePublishingAppLinkService appLinkService;

    protected ApplinkConnectionCommand(RemotePublisherService applinkRemotePublisherService, ConfluenceRemotePublishingAppLinkService appLinkService, Credentials credentials, String spaceKey, String configName) {
        super(applinkRemotePublisherService, credentials, spaceKey, configName);
        this.appLinkService = appLinkService;
    }

    @Override
    protected void validateCredentials() {
        List<ApplicationLink> applinks = this.appLinkService.getApplicationLinks();
        if (applinks.isEmpty()) {
            throw new RemotePublishingException("No applinks found. Check if the dark feature: \"" + DarkFeatureKey.APP_LINK + "\" is set in your instance.");
        }
        if (!this.appLinkService.isActiveApplinkConnection(this.spaceKey, ((AppLinkCredentials)this.credentials).getEntityLinkKey())) {
            throw new RemotePublishingException("Applink connection inactive for entity key: " + ((AppLinkCredentials)this.credentials).getEntityLinkName());
        }
        this.remotePublisherService.setCredentials(this.credentials, this.spaceKey, this.configName);
    }

    @Override
    protected ConnectionCommand prepareConnection() {
        return this;
    }
}

