/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.credentials.models;

import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UserCredentials
extends Credentials {
    private static final String PASS = "password";
    private static final String REMOTE = "remoteuser";
    private static final String USER = "user";
    private static final String PATH_URL = "url";
    private String url;
    private String loginUserName;
    private String password;
    private String remoteUserName;

    public UserCredentials(String url, String loginUserName, String password, String remoteSpaceKey, String remoteUserName) {
        this.setRemoteSpaceKey(remoteSpaceKey);
        this.url = url;
        this.loginUserName = loginUserName;
        this.password = password;
        this.remoteUserName = remoteUserName;
    }

    public UserCredentials(Map<String, Object> map) {
        super(map);
        this.url = (String)map.get(PATH_URL);
        this.loginUserName = (String)map.get(USER);
        this.password = (String)map.get(PASS);
        this.remoteUserName = (String)map.get(REMOTE);
    }

    @Override
    public void validate() throws NoSuchFieldException {
        super.validate();
        this.validate(this.url, PATH_URL);
        this.validate(this.loginUserName, USER);
        this.validate(this.password, PASS);
        this.validate(this.remoteUserName, REMOTE);
    }

    @Override
    public void override(Map<String, Object> parameters) {
        super.override(parameters);
        String value = (String)parameters.get(USER);
        if (value != null) {
            this.loginUserName = value;
        }
        if ((value = (String)parameters.get(PATH_URL)) != null) {
            this.url = value;
        }
        if ((value = (String)parameters.get(PASS)) != null) {
            this.password = value;
        }
        if ((value = (String)parameters.get(REMOTE)) != null) {
            this.remoteUserName = value;
        }
        if (!StringUtils.isNotBlank((CharSequence)this.remoteUserName)) {
            this.remoteUserName = this.loginUserName;
        }
    }

    @Override
    public String getConfluenceEnvironment() {
        String regex = "ATATT3xFfGF0.*=.{8}";
        Matcher matcher = Pattern.compile(regex).matcher(this.password);
        return matcher.matches() ? "cloud" : "server";
    }

    protected UserCredentials(UserCredentialsBuilder<?, ?> b) {
        super(b);
        this.url = b.url;
        this.loginUserName = b.loginUserName;
        this.password = b.password;
        this.remoteUserName = b.remoteUserName;
    }

    public static UserCredentialsBuilder<?, ?> builder() {
        return new UserCredentialsBuilderImpl();
    }

    public String getUrl() {
        return this.url;
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    @Override
    public String toString() {
        return "UserCredentials(url=" + this.getUrl() + ", loginUserName=" + this.getLoginUserName() + ", remoteUserName=" + this.getRemoteUserName() + ")";
    }

    public UserCredentials() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCredentials)) {
            return false;
        }
        UserCredentials other = (UserCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$loginUserName = this.getLoginUserName();
        String other$loginUserName = other.getLoginUserName();
        if (this$loginUserName == null ? other$loginUserName != null : !this$loginUserName.equals(other$loginUserName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$remoteUserName = this.getRemoteUserName();
        String other$remoteUserName = other.getRemoteUserName();
        return !(this$remoteUserName == null ? other$remoteUserName != null : !this$remoteUserName.equals(other$remoteUserName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserCredentials;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $loginUserName = this.getLoginUserName();
        result = result * 59 + ($loginUserName == null ? 43 : $loginUserName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $remoteUserName = this.getRemoteUserName();
        result = result * 59 + ($remoteUserName == null ? 43 : $remoteUserName.hashCode());
        return result;
    }

    private static final class UserCredentialsBuilderImpl
    extends UserCredentialsBuilder<UserCredentials, UserCredentialsBuilderImpl> {
        private UserCredentialsBuilderImpl() {
        }

        @Override
        protected UserCredentialsBuilderImpl self() {
            return this;
        }

        @Override
        public UserCredentials build() {
            return new UserCredentials(this);
        }
    }

    public static abstract class UserCredentialsBuilder<C extends UserCredentials, B extends UserCredentialsBuilder<C, B>>
    extends Credentials.CredentialsBuilder<C, B> {
        private String url;
        private String loginUserName;
        private String password;
        private String remoteUserName;

        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        public B loginUserName(String loginUserName) {
            this.loginUserName = loginUserName;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B remoteUserName(String remoteUserName) {
            this.remoteUserName = remoteUserName;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "UserCredentials.UserCredentialsBuilder(super=" + super.toString() + ", url=" + this.url + ", loginUserName=" + this.loginUserName + ", password=" + this.password + ", remoteUserName=" + this.remoteUserName + ")";
        }
    }
}

