/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.credentials.models;

import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import java.util.Map;
import java.util.Objects;

public class AppLinkCredentials
extends Credentials {
    private String entityLinkName;
    private String entityLinkKey;

    @Override
    public void validate() throws NoSuchFieldException {
        super.validate();
        this.validate(this.entityLinkName, "entityLinkName");
    }

    @Override
    public void override(Map<String, Object> parameters) {
        super.override(parameters);
        Object value = parameters.get("entityLinkName");
        if (value != null) {
            this.entityLinkName = (String)value;
        }
    }

    @Override
    public String getConfluenceEnvironment() {
        return Objects.nonNull(this.getRemoteSpaceId()) ? "cloud" : "server";
    }

    protected AppLinkCredentials(AppLinkCredentialsBuilder<?, ?> b) {
        super(b);
        this.entityLinkName = b.entityLinkName;
        this.entityLinkKey = b.entityLinkKey;
    }

    public static AppLinkCredentialsBuilder<?, ?> builder() {
        return new AppLinkCredentialsBuilderImpl();
    }

    public String getEntityLinkName() {
        return this.entityLinkName;
    }

    public String getEntityLinkKey() {
        return this.entityLinkKey;
    }

    public void setEntityLinkName(String entityLinkName) {
        this.entityLinkName = entityLinkName;
    }

    public void setEntityLinkKey(String entityLinkKey) {
        this.entityLinkKey = entityLinkKey;
    }

    @Override
    public String toString() {
        return "AppLinkCredentials(entityLinkName=" + this.getEntityLinkName() + ", entityLinkKey=" + this.getEntityLinkKey() + ")";
    }

    public AppLinkCredentials() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppLinkCredentials)) {
            return false;
        }
        AppLinkCredentials other = (AppLinkCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityLinkName = this.getEntityLinkName();
        String other$entityLinkName = other.getEntityLinkName();
        if (this$entityLinkName == null ? other$entityLinkName != null : !this$entityLinkName.equals(other$entityLinkName)) {
            return false;
        }
        String this$entityLinkKey = this.getEntityLinkKey();
        String other$entityLinkKey = other.getEntityLinkKey();
        return !(this$entityLinkKey == null ? other$entityLinkKey != null : !this$entityLinkKey.equals(other$entityLinkKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AppLinkCredentials;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityLinkName = this.getEntityLinkName();
        result = result * 59 + ($entityLinkName == null ? 43 : $entityLinkName.hashCode());
        String $entityLinkKey = this.getEntityLinkKey();
        result = result * 59 + ($entityLinkKey == null ? 43 : $entityLinkKey.hashCode());
        return result;
    }

    private static final class AppLinkCredentialsBuilderImpl
    extends AppLinkCredentialsBuilder<AppLinkCredentials, AppLinkCredentialsBuilderImpl> {
        private AppLinkCredentialsBuilderImpl() {
        }

        @Override
        protected AppLinkCredentialsBuilderImpl self() {
            return this;
        }

        @Override
        public AppLinkCredentials build() {
            return new AppLinkCredentials(this);
        }
    }

    public static abstract class AppLinkCredentialsBuilder<C extends AppLinkCredentials, B extends AppLinkCredentialsBuilder<C, B>>
    extends Credentials.CredentialsBuilder<C, B> {
        private String entityLinkName;
        private String entityLinkKey;

        public B entityLinkName(String entityLinkName) {
            this.entityLinkName = entityLinkName;
            return (B)this.self();
        }

        public B entityLinkKey(String entityLinkKey) {
            this.entityLinkKey = entityLinkKey;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AppLinkCredentials.AppLinkCredentialsBuilder(super=" + super.toString() + ", entityLinkName=" + this.entityLinkName + ", entityLinkKey=" + this.entityLinkKey + ")";
        }
    }
}

