/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.xstream;

import com.atlassian.confluence.labels.Namespace;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class NamespaceConverter
implements Converter {
    public boolean canConvert(Class aClass) {
        return aClass.equals(Namespace.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Namespace namespace = (Namespace)o;
        hierarchicalStreamWriter.startNode("namespacePrefix");
        hierarchicalStreamWriter.setValue(namespace.getPrefix());
        hierarchicalStreamWriter.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        hierarchicalStreamReader.moveDown();
        String namespacePrefix = hierarchicalStreamReader.getValue();
        hierarchicalStreamReader.moveUp();
        switch (namespacePrefix) {
            case "my": {
                return Namespace.PERSONAL;
            }
            case "team": {
                return Namespace.TEAM;
            }
            case "global": {
                return Namespace.GLOBAL;
            }
        }
        return Namespace.SYSTEM;
    }
}

