/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RestModelComponent {
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String NUMBER = "number";
    private static final String VERSION = "version";
    private static final String ID = "id";
    private static final String ANCESTORS = "ancestors";
    private static final String SPACE = "space";
    private static final String SPACE_ID = "spaceId";
    private static final String STORAGE = "storage";
    private static final String LINKS = "_links";
    private static final String WEBUI = "webui";
    private static final String STATUS = "status";
    private static final String VALUE = "value";
    private static final String REPRESENTATION = "representation";
    private static final String PARENT_ID = "parentId";
    private static final String BODY = "body";

    public JsonNode generateUpdateObject(Credentials credentials, String version, String pageTitle, String pageContent, String pageType, String parentPageId, String status, String remotePageId, String spaceId) {
        if (credentials.isCloudConfluenceEnvironment()) {
            return this.getUpdatedPageCloud(version, pageTitle, pageContent, pageType, parentPageId, status, remotePageId);
        }
        return this.getUpdatedPageServer(version, pageTitle, pageContent, pageType, parentPageId, spaceId);
    }

    private JsonNode getUpdatedPageCloud(String version, String pageTitle, String pageContent, String pageType, String parentPageId, String status, String remotePageId) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode updatedPage = mapper.createObjectNode();
        updatedPage.put(ID, remotePageId);
        updatedPage.put(TITLE, pageTitle);
        updatedPage.put(STATUS, status);
        this.setVersionNumber(version, updatedPage);
        if ("page".equals(pageType) && Objects.nonNull(parentPageId) && !"0".equals(parentPageId)) {
            updatedPage.put(PARENT_ID, parentPageId);
        }
        ObjectNode bodyJson = mapper.createObjectNode();
        bodyJson.put(VALUE, pageContent);
        bodyJson.put(REPRESENTATION, STORAGE);
        updatedPage.put(BODY, bodyJson);
        return updatedPage;
    }

    private JsonNode getUpdatedPageServer(String version, String pageTitle, String pageContent, String pageType, String parentPageId, String spaceId) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode updatedPage = mapper.createObjectNode();
        updatedPage.put(TYPE, pageType);
        updatedPage.put(TITLE, pageTitle);
        this.setVersionNumber(version, updatedPage);
        if ("page".equals(pageType)) {
            String parentForUpdatingPage = Objects.nonNull(parentPageId) && !"0".equals(parentPageId) ? parentPageId : spaceId;
            ArrayNode parentPageArray = mapper.createArrayNode();
            ObjectNode parentPage = mapper.createObjectNode();
            parentPage.put(ID, parentForUpdatingPage);
            parentPageArray.add(parentPage);
            updatedPage.put(ANCESTORS, parentPageArray);
        }
        ObjectNode bodyJson = mapper.createObjectNode();
        ObjectNode storageJson = mapper.createObjectNode();
        storageJson.put(VALUE, pageContent);
        storageJson.put(REPRESENTATION, STORAGE);
        bodyJson.put(STORAGE, storageJson);
        updatedPage.put(BODY, bodyJson);
        return updatedPage;
    }

    private void setVersionNumber(String version, ObjectNode updatedPage) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode versionNumber = mapper.createObjectNode();
        long newVersion = (long)Integer.parseInt(version) + 1L;
        versionNumber.put(NUMBER, newVersion);
        updatedPage.put(VERSION, versionNumber);
    }

    public JsonNode generatePageToUpdateAncestors(long version, long parentPageId, String childPageTitle) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode updatedPage = mapper.createObjectNode();
        ObjectNode versionNumber = mapper.createObjectNode();
        versionNumber.put(NUMBER, version);
        updatedPage.put(VERSION, versionNumber);
        ArrayNode parentPageArray = mapper.createArrayNode();
        ObjectNode parentPage = mapper.createObjectNode();
        parentPage.put(ID, parentPageId);
        parentPageArray.add(parentPage);
        updatedPage.put(ANCESTORS, parentPageArray);
        updatedPage.put(TITLE, childPageTitle);
        updatedPage.put(TYPE, "page");
        return updatedPage;
    }

    public String generatePageForCreation(String pageTitle, String pageContent, long remoteParentPageId, Credentials credentials) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode newPage = mapper.createObjectNode();
        newPage.put(TYPE, "page");
        newPage.put(TITLE, pageTitle);
        ObjectNode parentPage = mapper.createObjectNode();
        parentPage.put(TYPE, "page");
        parentPage.put(ID, remoteParentPageId);
        ArrayNode parentPageArray = mapper.createArrayNode();
        parentPageArray.add(parentPage);
        newPage.put(ANCESTORS, parentPageArray);
        ObjectNode spaceObj = mapper.createObjectNode();
        spaceObj.put("key", credentials.getRemoteSpaceKey());
        newPage.put(SPACE, spaceObj);
        ObjectNode storageObj = mapper.createObjectNode();
        storageObj.put(VALUE, pageContent);
        storageObj.put(REPRESENTATION, STORAGE);
        ObjectNode bodyObj = mapper.createObjectNode();
        bodyObj.put(STORAGE, storageObj);
        newPage.put(BODY, bodyObj);
        return newPage.toString();
    }

    public String generateCreatePageV2Payload(Page page, long remoteParentPageId, Credentials credentials) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode newPage = mapper.createObjectNode();
        newPage.put(SPACE_ID, credentials.getRemoteSpaceId());
        newPage.put(TITLE, page.getTitle());
        newPage.put(STATUS, page.getContentStatus());
        if (0L != remoteParentPageId) {
            newPage.put(PARENT_ID, remoteParentPageId);
        }
        ObjectNode body = mapper.createObjectNode();
        body.put(REPRESENTATION, STORAGE);
        body.put(VALUE, page.getBodyAsString());
        newPage.put(BODY, body);
        return newPage.toString();
    }

    public String generateCreateBlogPostV2Payload(BlogPost blogPost, Credentials credentials) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode newPage = mapper.createObjectNode();
        newPage.put(SPACE_ID, credentials.getRemoteSpaceId());
        newPage.put(STATUS, blogPost.getContentStatus());
        newPage.put(TITLE, blogPost.getTitle());
        ObjectNode body = mapper.createObjectNode();
        body.put(REPRESENTATION, STORAGE);
        body.put(VALUE, blogPost.getBodyAsString());
        newPage.put(BODY, body);
        return newPage.toString();
    }

    public RemotePageManifest createRemotePageManifest(Page page, JsonNode response, Credentials credentials) {
        String parentId = "0";
        String parentTitle = null;
        JsonNode ancestors = response.get(ANCESTORS);
        if (ancestors != null && !ancestors.isNull() && !ancestors.isEmpty()) {
            parentId = ancestors.get(0).get(ID).asText();
            parentTitle = ancestors.get(0).get(TITLE).asText();
        }
        return this.getRemotePageManifestBuilder(response, credentials).parentId(parentId).parentTitle(parentTitle).labels(this.filterPersonalLabels(page.getLabels())).build();
    }

    public RemotePageManifest generatePageOrBlogManifest(JsonNode response, Credentials credentials) {
        return this.getRemotePageManifestBuilder(response, credentials).build();
    }

    private RemotePageManifest.RemotePageManifestBuilder getRemotePageManifestBuilder(JsonNode response, Credentials credentials) {
        JsonNode spaceObject = response.get(SPACE);
        return RemotePageManifest.builder().version(response.get(VERSION).get(NUMBER).asText()).title(response.get(TITLE).asText()).spaceId(Objects.isNull(spaceObject) ? response.get(SPACE_ID).asText() : spaceObject.get(ID).asText()).pageId(response.get(ID).asText()).spaceKey(credentials.getRemoteSpaceKey()).url(response.get(LINKS).get(WEBUI).asText()).attachments(new ArrayList<RemoteAttachmentManifest>());
    }

    public RemotePageManifest updateRemotePageManifest(Page page, RemotePageManifest manifest) {
        manifest.setTitle(page.getTitle());
        String version = String.valueOf(Integer.parseInt(manifest.getVersion()) + 1);
        manifest.setVersion(version);
        if (page.getParent() != null && manifest.getParentId() != null && !manifest.getParentId().equals("0")) {
            manifest.setParentTitle(page.getParent().getTitle());
        } else {
            manifest.setParentTitle(null);
        }
        manifest.setLabels(this.filterPersonalLabels(page.getLabels()));
        return manifest;
    }

    public RemotePageManifest createRemoteBlogManifest(JsonNode response, Credentials credentials) {
        return this.getRemotePageManifestBuilder(response, credentials).build();
    }

    public RemotePageManifest updateRemoteBlogManifest(BlogPost blog, RemotePageManifest manifest) {
        manifest.setTitle(blog.getTitle());
        String version = String.valueOf(Integer.parseInt(manifest.getVersion()) + 1);
        manifest.setVersion(version);
        manifest.setLabels(this.filterPersonalLabels(blog.getLabels()));
        return manifest;
    }

    public List<Label> filterPersonalLabels(List<Label> labels) {
        ArrayList<Label> ret = new ArrayList<Label>();
        for (Label label : labels) {
            if (this.isPersonalLabel(label)) continue;
            ret.add(label);
        }
        return ret;
    }

    private boolean isPersonalLabel(Label label) {
        return this.isPersonalLabel(label.getNamespace().getPrefix());
    }

    private boolean isPersonalLabel(String prefix) {
        return Namespace.PERSONAL.getPrefix().equals(prefix);
    }
}

