/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.remotepublishing.CommonRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.PublishHistoryManager;
import com.comalatech.confluence.remotepublishing.applink.ConfluenceRemotePublishingAppLinkService;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.confluence.RemotePublisherService;
import com.comalatech.confluence.remotepublishing.utils.ApplinkConnectionCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ApplinkRemotePublishingManager
extends CommonRemotePublishingManager {
    private static final Logger log = LoggerFactory.getLogger(ApplinkRemotePublishingManager.class);
    private final ConfluenceRemotePublishingAppLinkService appLinkService;

    public ApplinkRemotePublishingManager(@Qualifier(value="applinkRemotePublisher") RemotePublisherService remotePublisherService, PublishHistoryManager publishHistoryManager, ConfluenceRemotePublishingAppLinkService appLinkService, @ComponentImport AttachmentManager attachmentManager, @ComponentImport XhtmlContent xhtmlContent) {
        super(remotePublisherService, publishHistoryManager, attachmentManager, xhtmlContent);
        this.appLinkService = appLinkService;
    }

    @Override
    public void checkCredentials(RemotePublishingConfiguration config, String spaceKey) {
        new ApplinkConnectionCommand(this.remotePublisherService, this.appLinkService, config.getCredentials(), spaceKey, config.getName()){

            @Override
            public void doExecute() {
                ApplinkRemotePublishingManager.this.checkCredentials();
            }
        }.execute();
    }

    @Override
    public void unpublish(final RemotePublishingConfiguration config, final AbstractPage page, final boolean purgeFromTrash) {
        log.debug("Unpublishing '{}'({}) {}", new Object[]{page.getTitle(), page.getSpaceKey(), purgeFromTrash});
        new ApplinkConnectionCommand(this.remotePublisherService, this.appLinkService, config.getCredentials(), page.getSpaceKey(), config.getName()){

            @Override
            public void doExecute() {
                ApplinkRemotePublishingManager.this.unpublish(page, config.getCredentials(), config.getName(), purgeFromTrash);
            }
        }.execute();
    }

    @Override
    public void publish(final RemotePublishingConfiguration config, final AbstractPage page) {
        log.debug("Publishing page or blogpost '{}'({})", (Object)page.getTitle(), (Object)page.getSpaceKey());
        log.debug("Credentials: {}", (Object)config.getCredentials());
        new ApplinkConnectionCommand(this.remotePublisherService, this.appLinkService, config.getCredentials(), page.getSpaceKey(), config.getName()){

            @Override
            public void doExecute() {
                ApplinkRemotePublishingManager.this.publish(page, config.getCredentials(), config.getName());
            }
        }.execute();
    }

    void checkCredentials() {
        this.remotePublisherService.checkRemoteSpace();
    }
}

