/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerUtils {
    private static final Logger log = LoggerFactory.getLogger(TimerUtils.class);
    public static String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static String DATE_FORMAT_NOTIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    public static Date parseDate(String value) throws ParseException {
        try {
            return TimerUtils.getFormatter().parse(value);
        }
        catch (ParseException e) {
            int ix = value.lastIndexOf(" ");
            if (ix > 0 && ix < value.length() - 1) {
                Date date = TimerUtils.getFormatterNoTimeZone().parse(value.substring(0, ix));
                if (log.isDebugEnabled()) {
                    log.debug("ignoring timezone " + value.substring(ix));
                    log.debug("ignoring timezone {}", (Object)value.substring(ix));
                }
                return date;
            }
            throw e;
        }
    }

    public static SimpleDateFormat getFormatter() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public static SimpleDateFormat getFormatterNoTimeZone() {
        return new SimpleDateFormat(DATE_FORMAT_NOTIMEZONE);
    }
}

