/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

AJS.toInit(function () {

    jQuery("a.removeConfigLink").click(function () {
        return confirm('Are you sure you want to remove this configuration?');
    });

    document.querySelectorAll("input[name='configurationType']").forEach(radioButton => {
        radioButton.addEventListener("change", () => {
            const selectedValue = document.querySelector("input[name='configurationType']:checked").value;
            toggleVisibility(".configurationUserDiv", selectedValue !== 'applink');
            toggleVisibility(".configurationApplinkDiv", selectedValue === 'applink');
        });
    });

    const toggleVisibility = (selector, isVisible) => {
        document.querySelectorAll(selector).forEach(element => {
            element.style.display = isVisible ? 'block' : 'none';
        });
    }
});