/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import com.atlassian.confluence.pages.Attachment;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.credentials.models.UserCredentials;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BaseRestApiAction
implements ApiAction {
    private static final Logger log = LoggerFactory.getLogger(BaseRestApiAction.class);
    private String hostUrl = "";
    private CookieStore cookieStore;
    private StringEntity stringEntity;
    private HttpEntity entity;
    private String atlassianToken = null;
    private MultipartEntityBuilder multipartEntityBuilder;
    private HttpClient client;

    @Override
    public void setRemoteCredentials(Credentials credentials, String spaceKey) {
        UserCredentials userCredentials = (UserCredentials)credentials;
        String authorization = userCredentials.getRemoteUserName() + ":" + userCredentials.getPassword();
        this.hostUrl = ((UserCredentials)credentials).getUrl();
        String encodedAuth = Base64.getEncoder().encodeToString(authorization.getBytes());
        BasicHeader header = new BasicHeader("Authorization", "Basic " + encodedAuth);
        this.cookieStore = new BasicCookieStore();
        RequestConfig config = RequestConfig.custom().setCookieSpec("standard").build();
        this.client = HttpClientBuilder.create().setDefaultCookieStore(this.cookieStore).setDefaultRequestConfig(config).setDefaultHeaders(Collections.singleton(header)).build();
    }

    @Override
    public JsonNode httpGetPetition(ConfluenceRestAPI petitionType, boolean getJson, boolean useToken, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doGetConnection(formattedUrl, getJson, useToken);
    }

    @Override
    public JsonNode httpGetPetition(String url, boolean getJson, boolean useToken, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(url, urlParameters);
        return this.doGetConnection(formattedUrl, getJson, useToken);
    }

    @Override
    public JsonNode httpPostPetition(ConfluenceRestAPI petitionType, boolean getJson, boolean removeAtlassianTokenCheck, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPostConnection(formattedUrl, getJson, removeAtlassianTokenCheck);
    }

    @Override
    public JsonNode httpPostPetition(StringEntity stringEntity, ConfluenceRestAPI petitionType, boolean getJson, boolean removeAtlassianTokenCheck, String ... urlParameters) {
        this.stringEntity = stringEntity;
        return this.httpPostPetition(petitionType, getJson, removeAtlassianTokenCheck, urlParameters);
    }

    @Override
    public JsonNode httpPostPetition(List<NameValuePair> form, ConfluenceRestAPI petitionType, boolean getJson, boolean useToken) {
        if (useToken) {
            form.add((NameValuePair)new BasicNameValuePair("atl_token", this.getAtlassianToken()));
        }
        this.stringEntity = new UrlEncodedFormEntity(form, StandardCharsets.UTF_8);
        return this.httpPostPetition(petitionType, getJson, false, new String[0]);
    }

    @Override
    public JsonNode httpPostPetition(MultipartEntityBuilder multipartEntityBuilder, ConfluenceRestAPI petitionType, boolean getJson, boolean removeAtlassianTokenCheck, Attachment attachment, String ... urlParameters) {
        this.multipartEntityBuilder = multipartEntityBuilder;
        return this.httpPostPetition(petitionType, getJson, removeAtlassianTokenCheck, urlParameters);
    }

    @Override
    public JsonNode httpPutPetition(StringEntity stringEntity, ConfluenceRestAPI petitionType, String ... urlParameters) {
        this.stringEntity = stringEntity;
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPutConnection(formattedUrl);
    }

    @Override
    public JsonNode httpDeletePetition(ConfluenceRestAPI petitionType, boolean getJson, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doDeleteConnection(formattedUrl, getJson);
    }

    private String generatePageUrl(String urlFormat, String ... urlParameters) {
        if (urlParameters.length > 0) {
            this.encodeParameters(urlParameters);
            MessageFormat messageFormat = new MessageFormat(urlFormat);
            return this.hostUrl + messageFormat.format(urlParameters);
        }
        return this.hostUrl + urlFormat;
    }

    private void encodeParameters(String ... urlParameters) {
        for (int i = 0; i < urlParameters.length; ++i) {
            urlParameters[i] = URLEncoder.encode(urlParameters[i], StandardCharsets.UTF_8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode doPostConnection(String url, boolean getJson, boolean removeAtlassianTokenCheck) {
        try {
            HttpPost postPage = new HttpPost(url);
            if (this.stringEntity != null) {
                postPage.setEntity((HttpEntity)this.stringEntity);
            } else if (removeAtlassianTokenCheck) {
                postPage.setHeader("X-Atlassian-Token", "no-check");
                postPage.setEntity(this.multipartEntityBuilder.build());
            }
            HttpResponse response = this.client.execute((HttpUriRequest)postPage);
            log.debug("calling POST to {},transformBoolean {} with response {}", new Object[]{url, getJson, response});
            this.entity = response.getEntity();
            if (getJson) {
                JsonNode jsonNode = this.getJsonFromEntity(this.entity);
                return jsonNode;
            }
            JsonNode jsonNode = this.checkStatusCode(response.getStatusLine().getStatusCode());
            return jsonNode;
        }
        catch (IOException e) {
            log.error("error doing post connection", e.getCause());
        }
        finally {
            this.multipartEntityBuilder = null;
            this.stringEntity = null;
            this.consumeEntity();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode doGetConnection(String url, boolean getJson, boolean useToken) {
        try {
            if (useToken) {
                url = this.checkUrlContainsToken(url);
            }
            HttpGet getPage = new HttpGet(url);
            HttpResponse response = this.client.execute((HttpUriRequest)getPage);
            log.debug("calling GET to {}, transformBoolean {} with response {}", new Object[]{url, getJson, response});
            this.entity = response.getEntity();
            if (getJson) {
                JsonNode jsonNode = this.getJsonFromEntity(this.entity);
                return jsonNode;
            }
            JsonNode jsonNode = this.checkStatusCode(response.getStatusLine().getStatusCode());
            return jsonNode;
        }
        catch (IOException e) {
            log.error("error doing get connection", e.getCause());
        }
        finally {
            this.consumeEntity();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode doPutConnection(String url) {
        try {
            HttpResponse response;
            HttpPut putPage = new HttpPut(url);
            if (this.stringEntity != null) {
                putPage.setEntity((HttpEntity)this.stringEntity);
            }
            if ((response = this.client.execute((HttpUriRequest)putPage)).getStatusLine().getStatusCode() != 200) {
                log.error("error on calling put request; to {} payload {}, with response {}", new Object[]{url, this.entity, response});
            }
            log.debug("calling PUT to {} payload {}, with response {}", new Object[]{url, this.entity, response});
            this.entity = response.getEntity();
            JsonNode result = this.getJsonFromEntity(this.entity);
            if (result != null) {
                JsonNode jsonNode = result;
                return jsonNode;
            }
            JsonNode jsonNode = this.checkStatusCode(response.getStatusLine().getStatusCode());
            return jsonNode;
        }
        catch (IOException e) {
            log.error("error doing put connection", e.getCause());
        }
        finally {
            this.stringEntity = null;
            this.consumeEntity();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode doDeleteConnection(String url, boolean getJson) {
        try {
            HttpDelete deletePage = new HttpDelete(url);
            HttpResponse response = this.client.execute((HttpUriRequest)deletePage);
            log.debug("calling DELETE to {}, transformBoolean {} with response {}", new Object[]{url, getJson, response});
            this.entity = response.getEntity();
            if (getJson) {
                JsonNode jsonNode = this.getJsonFromEntity(this.entity);
                return jsonNode;
            }
            JsonNode jsonNode = this.checkStatusCode(response.getStatusLine().getStatusCode());
            return jsonNode;
        }
        catch (IOException e) {
            log.error("error doing delete connection", e.getCause());
        }
        finally {
            this.consumeEntity();
        }
        return null;
    }

    private JsonNode getJsonFromEntity(HttpEntity entity) {
        try {
            String jsonString = EntityUtils.toString((HttpEntity)entity);
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readTree(jsonString);
        }
        catch (Exception e) {
            log.error("error getting json from entity", e.getCause());
            return null;
        }
    }

    private void consumeEntity() {
        try {
            EntityUtils.consume((HttpEntity)this.entity);
        }
        catch (IOException e) {
            log.error("error consuming entity", e.getCause());
        }
    }

    private JsonNode checkStatusCode(int statusCode) {
        if (statusCode != 200 && statusCode != 202 && statusCode != 204 && statusCode != 302) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.createObjectNode();
    }

    private String getAtlassianToken() {
        HttpGet getTokenPage = new HttpGet(this.hostUrl);
        getTokenPage.setHeader("Content-Type", "text/html");
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)getTokenPage);
            String pageHtml = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            this.atlassianToken = StringUtils.substringBetween((String)pageHtml, (String)"name=\"atlassian-token\" content=\"", (String)"\">");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.atlassianToken;
    }

    private String checkUrlContainsToken(String url) {
        return url + this.getAtlassianToken();
    }
}

