/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.model;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class RemotePageManifest {
    String title;
    String version;
    String pageId;
    String parentId;
    String parentTitle;
    String url;
    String spaceKey;
    String spaceId;
    List<RemoteAttachmentManifest> attachments;
    List<Label> labels;

    public RemoteAttachmentManifest getAttachment(String filename) {
        return this.attachments.stream().filter(a -> a.getFilename().equals(filename)).findFirst().orElse(null);
    }

    public void addAttachment(RemoteAttachmentManifest remoteAttachmentManifest) {
        if (Objects.isNull(this.attachments)) {
            this.attachments = new ArrayList<RemoteAttachmentManifest>();
        }
        this.attachments.add(remoteAttachmentManifest);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemotePageManifest that = (RemotePageManifest)o;
        return this.title.equals(that.title) && this.version.equals(that.version) && this.pageId.equals(that.pageId) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.parentTitle, that.parentTitle) && this.url.equals(that.url) && Objects.equals(this.spaceKey, that.spaceKey) && Objects.equals(this.spaceId, that.spaceId) && Objects.equals(this.attachments, that.attachments) && Objects.equals(this.labels, that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.version, this.pageId, this.parentId, this.parentTitle, this.url, this.spaceKey, this.spaceId, this.attachments, this.labels);
    }

    public static RemotePageManifestBuilder builder() {
        return new RemotePageManifestBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getParentTitle() {
        return this.parentTitle;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public List<RemoteAttachmentManifest> getAttachments() {
        return this.attachments;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setParentTitle(String parentTitle) {
        this.parentTitle = parentTitle;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public void setAttachments(List<RemoteAttachmentManifest> attachments) {
        this.attachments = attachments;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public RemotePageManifest(String title, String version, String pageId, String parentId, String parentTitle, String url, String spaceKey, String spaceId, List<RemoteAttachmentManifest> attachments, List<Label> labels) {
        this.title = title;
        this.version = version;
        this.pageId = pageId;
        this.parentId = parentId;
        this.parentTitle = parentTitle;
        this.url = url;
        this.spaceKey = spaceKey;
        this.spaceId = spaceId;
        this.attachments = attachments;
        this.labels = labels;
    }

    public RemotePageManifest() {
    }

    public static class RemotePageManifestBuilder {
        private String title;
        private String version;
        private String pageId;
        private String parentId;
        private String parentTitle;
        private String url;
        private String spaceKey;
        private String spaceId;
        private List<RemoteAttachmentManifest> attachments;
        private List<Label> labels;

        RemotePageManifestBuilder() {
        }

        public RemotePageManifestBuilder title(String title) {
            this.title = title;
            return this;
        }

        public RemotePageManifestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public RemotePageManifestBuilder pageId(String pageId) {
            this.pageId = pageId;
            return this;
        }

        public RemotePageManifestBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public RemotePageManifestBuilder parentTitle(String parentTitle) {
            this.parentTitle = parentTitle;
            return this;
        }

        public RemotePageManifestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public RemotePageManifestBuilder spaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public RemotePageManifestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public RemotePageManifestBuilder attachments(List<RemoteAttachmentManifest> attachments) {
            this.attachments = attachments;
            return this;
        }

        public RemotePageManifestBuilder labels(List<Label> labels) {
            this.labels = labels;
            return this;
        }

        public RemotePageManifest build() {
            return new RemotePageManifest(this.title, this.version, this.pageId, this.parentId, this.parentTitle, this.url, this.spaceKey, this.spaceId, this.attachments, this.labels);
        }

        public String toString() {
            return "RemotePageManifest.RemotePageManifestBuilder(title=" + this.title + ", version=" + this.version + ", pageId=" + this.pageId + ", parentId=" + this.parentId + ", parentTitle=" + this.parentTitle + ", url=" + this.url + ", spaceKey=" + this.spaceKey + ", spaceId=" + this.spaceId + ", attachments=" + this.attachments + ", labels=" + this.labels + ")";
        }
    }
}

