/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.credentials.converter;

import com.comalatech.confluence.remotepublishing.credentials.models.AppLinkCredentials;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.credentials.models.UserCredentials;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(CredentialsConverter.class);

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Credentials credentials = (Credentials)source;
        writer.startNode("credentials");
        writer.startNode("remoteSpaceKey");
        writer.setValue(credentials.getRemoteSpaceKey());
        writer.endNode();
        writer.startNode("remoteSpaceId");
        writer.setValue(Objects.nonNull(credentials.getRemoteSpaceId()) ? String.valueOf(credentials.getRemoteSpaceId()) : "");
        writer.endNode();
        Class<?> credentialsClass = credentials.getClass();
        for (Field field : credentialsClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String fieldName = field.getName();
            try {
                Method getter = credentialsClass.getMethod("get" + com.atlassian.extras.common.org.springframework.util.StringUtils.capitalize((String)fieldName), new Class[0]);
                Object value = getter.invoke((Object)credentials, new Object[0]);
                writer.startNode(fieldName);
                writer.setValue(value != null ? value.toString() : "");
                writer.endNode();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                log.error("ERROR - MARSHALING ", (Throwable)ex);
            }
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String url = null;
        String remoteSpaceKey = null;
        Long remoteSpaceId = null;
        String loginUserName = null;
        String password = null;
        String remoteUserName = null;
        String entityLinkName = null;
        String entityLinkKey = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if ("url".equals(nodeName)) {
                url = reader.getValue();
            } else if ("loginUserName".equals(nodeName)) {
                loginUserName = reader.getValue();
            } else if ("password".equals(nodeName)) {
                password = reader.getValue();
            } else if ("remoteSpaceKey".equals(nodeName)) {
                remoteSpaceKey = reader.getValue();
            } else if ("remoteUserName".equals(nodeName)) {
                remoteUserName = reader.getValue();
            } else if ("remoteSpaceId".equals(nodeName)) {
                remoteSpaceId = StringUtils.isNotBlank((CharSequence)reader.getValue()) ? Long.valueOf(reader.getValue()) : null;
            } else if ("entityLinkName".equals(nodeName)) {
                entityLinkName = reader.getValue();
            } else if ("entityLinkKey".equals(nodeName)) {
                entityLinkKey = reader.getValue();
            }
            reader.moveUp();
        }
        Credentials credentials = StringUtils.isBlank(password) ? ((AppLinkCredentials.AppLinkCredentialsBuilder)((AppLinkCredentials.AppLinkCredentialsBuilder)((AppLinkCredentials.AppLinkCredentialsBuilder)((AppLinkCredentials.AppLinkCredentialsBuilder)AppLinkCredentials.builder().remoteSpaceKey(remoteSpaceKey)).remoteSpaceId(remoteSpaceId)).entityLinkKey(entityLinkKey)).entityLinkName(entityLinkName)).build() : ((UserCredentials.UserCredentialsBuilder)((UserCredentials.UserCredentialsBuilder)((UserCredentials.UserCredentialsBuilder)((UserCredentials.UserCredentialsBuilder)((UserCredentials.UserCredentialsBuilder)((Credentials.CredentialsBuilder)UserCredentials.builder().url(url)).remoteSpaceKey(remoteSpaceKey)).remoteSpaceId(remoteSpaceId)).loginUserName(loginUserName)).password(password)).remoteUserName(remoteUserName)).build();
        return credentials;
    }

    public boolean canConvert(Class type) {
        return Credentials.class.isAssignableFrom(type);
    }
}

