/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import com.comalatech.confluence.remotepublishing.confluence.RemotePublisherService;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionCommand {
    private static final Logger log = LoggerFactory.getLogger(ConnectionCommand.class);
    protected final Credentials credentials;
    protected final String spaceKey;
    protected final String configName;
    protected final RemotePublisherService remotePublisherService;

    protected ConnectionCommand(RemotePublisherService remotePublisherService, Credentials credentials, String spaceKey, String configName) {
        this.credentials = credentials;
        this.spaceKey = spaceKey;
        this.configName = configName;
        this.remotePublisherService = remotePublisherService;
    }

    protected ConnectionCommand validate() {
        this.validateCredentials();
        return this;
    }

    protected abstract void validateCredentials();

    protected abstract ConnectionCommand prepareConnection();

    public void execute() {
        this.validate().prepareConnection().doExecute();
    }

    public abstract void doExecute();
}

