/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.manifest;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperation;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.TimerUtils;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceCloudRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceContentType;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceDCRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AttachmentManifestOperation
implements RemoteManifestOperation {
    private final RemotePageManifest remotePageManifest;
    private final ApiAction apiAction;
    private final Credentials credentials;
    private final String type;

    public AttachmentManifestOperation(ApiAction apiAction, RemotePageManifest remotePageManifest, Credentials credentials, String type) {
        this.apiAction = apiAction;
        this.remotePageManifest = remotePageManifest;
        this.credentials = credentials;
        this.type = type;
    }

    @Override
    public void add() {
        JsonNode response;
        Enum apiUrlOperation = ConfluenceDCRestApi.CONTENT_ATTACHMENTS;
        if (this.credentials.isCloudConfluenceEnvironment()) {
            apiUrlOperation = ConfluenceContentType.isPage(this.type) ? ConfluenceCloudRestApi.GET_PAGE_ATTACHMENTS : ConfluenceCloudRestApi.GET_BLOGPOST_ATTACHMENTS;
            response = this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)apiUrlOperation), true, false, new String[]{this.remotePageManifest.getPageId()});
        } else {
            response = this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)apiUrlOperation), true, false, new String[]{this.remotePageManifest.getPageId(), "0", "50"});
        }
        if (response != null) {
            boolean hasMore = true;
            while (hasMore) {
                hasMore = response.get("_links").has("next");
                JsonNode attachments = response.get("results");
                if (attachments.isArray()) {
                    for (JsonNode attachment : attachments) {
                        this.remotePageManifest.addAttachment(this.buildRemoteAttachmentManifest(attachment, this.remotePageManifest.getPageId()));
                    }
                }
                if (!hasMore) continue;
                response = this.apiAction.httpGetPetition(response.get("_links").get("next").asText(), true, false, new String[0]);
            }
        }
    }

    private RemoteAttachmentManifest buildRemoteAttachmentManifest(JsonNode attachment, String manifestPageId) {
        if (this.credentials.isCloudConfluenceEnvironment()) {
            return this.buildCloudRemoteAttachmentManifest(attachment);
        }
        return this.buildDataCenterRemoteAttachmentManifest(manifestPageId, attachment);
    }

    private RemoteAttachmentManifest buildCloudRemoteAttachmentManifest(JsonNode attachment) {
        String id = this.getAttachmentId(attachment);
        String fileName = attachment.get("title").asText();
        int fileSize = attachment.get("fileSize").intValue();
        ArrayList<Label> labelList = new ArrayList<Label>();
        JsonNode remoteAttachmentData = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.GET_ATTACHMENT_BY_ID, true, false, id);
        if (remoteAttachmentData != null) {
            JsonNode attachmentsLabelsResponse = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.GET_LABEL_ATTACHMENTS, true, false, id);
            JsonNode results = attachmentsLabelsResponse.get("results");
            this.setAttachmentLabels(labelList, results);
        }
        return new RemoteAttachmentManifest(id, fileName, this.getAttachmentVersion(remoteAttachmentData), fileSize, this.getAttachmentCreatedDate(remoteAttachmentData), this.getAttachmentComment(remoteAttachmentData), labelList);
    }

    private RemoteAttachmentManifest buildDataCenterRemoteAttachmentManifest(String remotePageId, JsonNode attachment) {
        String fileName = this.getAttachmentFilename(attachment);
        int fileSize = attachment.get("extensions").get("fileSize").intValue();
        JsonNode responseRemoteAttachmentData = this.apiAction.httpGetPetition(ConfluenceDCRestApi.ATTACHMENT_DATA, true, false, remotePageId, fileName);
        Date createdDate = null;
        String comment = null;
        int version = 0;
        ArrayList<Label> labelList = new ArrayList<Label>();
        if (responseRemoteAttachmentData != null) {
            JsonNode remoteAttachmentData = responseRemoteAttachmentData.get("results").get(0);
            version = this.getAttachmentVersion(remoteAttachmentData);
            String createdDateString = remoteAttachmentData.get("history").get("createdDate").asText();
            try {
                createdDate = TimerUtils.parseDate(createdDateString);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            JsonNode metadata = attachment.get("metadata");
            comment = "";
            if (metadata != null) {
                JsonNode labels;
                JsonNode commentJson = metadata.get("comment");
                if (commentJson != null) {
                    comment = commentJson.asText();
                }
                if ((labels = metadata.get("labels")) != null) {
                    JsonNode results = labels.get("results");
                    this.setAttachmentLabels(labelList, results);
                }
            }
        }
        return new RemoteAttachmentManifest(this.getAttachmentId(attachment), fileName, version, fileSize, createdDate, comment, labelList);
    }

    private void setAttachmentLabels(List<Label> labels, JsonNode results) {
        if (results != null && results.isArray()) {
            results.forEach(l -> labels.add(new Label(l.get("name").asText(), l.get("prefix").asText())));
        }
    }

    private int getAttachmentVersion(JsonNode attachmentData) {
        if (attachmentData.isNull() || attachmentData.get("version").isNull() || attachmentData.get("version").get("number").isNull()) {
            return 0;
        }
        return attachmentData.get("version").get("number").asInt();
    }

    private Date getAttachmentCreatedDate(JsonNode attachmentData) {
        if (attachmentData.isNull() || attachmentData.get("version").isNull() || attachmentData.get("version").get("createdAt").isNull()) {
            return null;
        }
        String createdDateString = attachmentData.get("version").get("createdAt").asText();
        try {
            return TimerUtils.parseDate(createdDateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private String getAttachmentComment(JsonNode attachmentData) {
        if (attachmentData.isNull() || attachmentData.get("comment").isNull() || attachmentData.get("version").get("number").isNull()) {
            return null;
        }
        return attachmentData.get("comment").asText();
    }

    private String getAttachmentId(JsonNode attachmentData) {
        if (attachmentData == null || attachmentData.get("id").isNull()) {
            return null;
        }
        return attachmentData.get("id").asText();
    }

    private String getAttachmentFilename(JsonNode attachmentData) {
        if (attachmentData == null || attachmentData.get("title").isNull()) {
            return null;
        }
        return attachmentData.get("title").asText();
    }
}

