/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.manifest;

import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperation;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceCloudRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceDCRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.fasterxml.jackson.databind.JsonNode;

public class AncestorManifestOperation
implements RemoteManifestOperation {
    private final RemotePageManifest remotePageManifest;
    private final ApiAction apiAction;
    private final Credentials credentials;

    public AncestorManifestOperation(ApiAction apiAction, RemotePageManifest remotePageManifest, Credentials credentials) {
        this.apiAction = apiAction;
        this.remotePageManifest = remotePageManifest;
        this.credentials = credentials;
    }

    @Override
    public void add() {
        JsonNode response = this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)(this.credentials.isCloudConfluenceEnvironment() ? ConfluenceCloudRestApi.GET_PAGE_ANCESTORS : ConfluenceDCRestApi.CONTENT_ANCESTORS)), true, false, this.remotePageManifest.getPageId());
        if (this.credentials.isCloudConfluenceEnvironment()) {
            this.buildCloudRemoteAttachmentManifest(response);
        } else {
            this.buildDataCenterRemoteAttachmentManifest(response);
        }
    }

    private void buildDataCenterRemoteAttachmentManifest(JsonNode ancestorResponse) {
        int totalAncestors;
        JsonNode ancestors = ancestorResponse.get("ancestors");
        int n = totalAncestors = !ancestors.isNull() && ancestors.isArray() ? ancestors.size() : 0;
        if (totalAncestors != 0) {
            this.remotePageManifest.setParentId(ancestors.get(totalAncestors - 1).get("id").asText());
            this.remotePageManifest.setParentTitle(ancestors.get(totalAncestors - 1).get("title").asText());
        } else {
            this.remotePageManifest.setParentId("0");
            this.remotePageManifest.setParentTitle(null);
        }
    }

    private void buildCloudRemoteAttachmentManifest(JsonNode ancestorResponse) {
        int totalAncestors;
        JsonNode ancestors = ancestorResponse.get("results");
        int n = totalAncestors = !ancestors.isNull() && ancestors.isArray() ? ancestors.size() : 0;
        if (totalAncestors != 0) {
            String parentId = ancestors.get(totalAncestors - 1).get("id").asText();
            this.remotePageManifest.setParentId(parentId);
            JsonNode parentResponse = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.GET_PAGE, true, false, parentId);
            String parentTitle = parentResponse.get("title").asText();
            this.remotePageManifest.setParentTitle(parentTitle);
        } else {
            this.remotePageManifest.setParentId("0");
            this.remotePageManifest.setParentTitle(null);
        }
    }
}

