/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.comalatech.confluence.remotepublishing.PublishHistoryManager;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RemotePublishingManager;
import com.comalatech.confluence.remotepublishing.confluence.RemotePublisherService;
import com.comalatech.confluence.remotepublishing.credentials.models.AppLinkCredentials;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.credentials.models.UserCredentials;
import com.comalatech.confluence.remotepublishing.diagrams.DiagramProcessor;
import com.comalatech.confluence.remotepublishing.diagrams.DrawIoProcessor;
import com.comalatech.confluence.remotepublishing.model.PublishHistoryInfo;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceContentType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRemotePublishingManager
implements RemotePublishingManager {
    private static final Logger log = LoggerFactory.getLogger(CommonRemotePublishingManager.class);
    private static final String DRAW_IO_MACRO_NAME = "drawio";
    private static final String DRAW_IO_TAG = "ac:name=\"drawio\"";
    protected final RemotePublisherService remotePublisherService;
    private final PublishHistoryManager publishHistoryManager;
    private final AttachmentManager attachmentManager;
    private final XhtmlContent xhtmlContent;

    protected CommonRemotePublishingManager(RemotePublisherService remotePublisherService, PublishHistoryManager publishHistoryManager, AttachmentManager attachmentManager, XhtmlContent xhtmlContent) {
        this.remotePublisherService = remotePublisherService;
        this.publishHistoryManager = publishHistoryManager;
        this.attachmentManager = attachmentManager;
        this.xhtmlContent = xhtmlContent;
    }

    void unpublish(AbstractPage page, Credentials credentials, String configName, boolean purgeFromTrash) {
        try {
            RemotePageManifest manifest = this.getPreviousPublishPageManifest(page, configName, credentials);
            if (manifest != null) {
                if (ConfluenceContentType.isPage(page.getType())) {
                    this.remotePublisherService.removeRemotePage(manifest.getPageId(), purgeFromTrash);
                } else {
                    this.remotePublisherService.removeRemoteBlogpost(manifest.getPageId(), purgeFromTrash);
                }
            }
        }
        catch (Exception e) {
            throw new RemotePublishingException("Unpublishing error", e);
        }
    }

    private void validateCredentialsAndSetDefaults(Credentials credentials) {
        if (credentials instanceof UserCredentials) {
            UserCredentials userCredentials = (UserCredentials)credentials;
            if (userCredentials.getRemoteUserName() == null) {
                userCredentials.setRemoteUserName(AuthenticatedUserThreadLocal.getUsername());
            }
            try {
                userCredentials.validate();
            }
            catch (Exception e) {
                throw new RemotePublishingException("Invalid publishing credentials: " + e.getMessage());
            }
        }
    }

    public void publish(AbstractPage page, Credentials credentials, String configName) throws RemotePublishingException {
        log.debug("Publishing page or blogpost '" + page.getTitle() + "'(" + page.getSpaceKey() + ")");
        log.debug("Credentials: " + credentials);
        this.validateCredentialsAndSetDefaults(credentials);
        this.remotePublisherService.setCredentials(credentials, page.getSpaceKey(), configName);
        try {
            RemotePageManifest manifest = this.getValidManifest(page, configName, credentials);
            if (manifest != null) {
                String bodyContent = page.getBodyAsString();
                if (this.isDiagramMacro(bodyContent, body -> body.contains(DRAW_IO_TAG)) && this.getDiagramProcessor().isPresent()) {
                    String diagramBodyContent = ((DrawIoProcessor)this.getDiagramProcessor().get()).updateDrawIODiagramBodyContent(page, manifest);
                    page.setBodyAsString(diagramBodyContent);
                    manifest = this.remotePublisherService.updateRemote(page, manifest);
                    page.setBodyAsString(bodyContent);
                } else {
                    manifest = this.remotePublisherService.updateRemote(page, manifest);
                }
            } else {
                manifest = this.remotePublisherService.createRemote(page);
            }
            this.publishAttachments(manifest, this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page));
            PublishHistoryInfo publishInfo = credentials instanceof UserCredentials ? new PublishHistoryInfo(manifest, ((UserCredentials)credentials).getUrl(), null) : new PublishHistoryInfo(manifest, null, ((AppLinkCredentials)credentials).getEntityLinkKey());
            this.publishHistoryManager.addPublishHistoryInfo(page, configName, publishInfo);
        }
        catch (Exception e) {
            throw new RemotePublishingException("There was an error while publishing content", e);
        }
    }

    protected RemotePageManifest getPreviousPublishPageManifest(AbstractPage page, String configName, Credentials credentials) {
        PublishHistoryInfo publishHistoryInfo;
        if ((page instanceof Page || page instanceof BlogPost) && (publishHistoryInfo = this.publishHistoryManager.getLatestPublishHistoryInfo(page, configName)) != null && StringUtils.equals((CharSequence)credentials.getRemoteSpaceKey(), (CharSequence)publishHistoryInfo.getRemotePageManifest().getSpaceKey())) {
            return publishHistoryInfo.getRemotePageManifest();
        }
        return null;
    }

    private RemotePageManifest getValidManifest(AbstractPage absPage, String configName, Credentials credentials) {
        RemotePageManifest manifest = this.getPreviousPublishPageManifest(absPage, configName, credentials);
        RemotePageManifest remoteManifest = this.remotePublisherService.getRemoteContentManifest(absPage, manifest);
        if (remoteManifest == null) {
            return null;
        }
        if (manifest == null || manifest.getSpaceId() == null || !manifest.equals(remoteManifest)) {
            List<RemoteAttachmentManifest> localAttachments;
            if (manifest != null && Objects.nonNull(localAttachments = manifest.getAttachments()) && Objects.nonNull(remoteManifest.getAttachments())) {
                for (RemoteAttachmentManifest remoteAttachmentManifest : remoteManifest.getAttachments()) {
                    localAttachments.stream().filter(localManifest -> localManifest.getId().equals(remoteAttachmentManifest.getId())).findFirst().ifPresent(attachmentManifest -> remoteAttachmentManifest.setLocalId(attachmentManifest.getLocalId()));
                }
            }
            return remoteManifest;
        }
        return manifest;
    }

    private void publishAttachments(RemotePageManifest pageManifest, List<Attachment> attachments) throws RemotePublishingException, IOException {
        log.debug("Publishing attachments for absPage '{}'({})", (Object)pageManifest.getTitle(), (Object)pageManifest.getSpaceKey());
        this.updateOrAddAttachments(pageManifest, attachments);
        this.removeRemoteAttachments(pageManifest, attachments);
    }

    private void removeRemoteAttachments(RemotePageManifest pageManifest, List<Attachment> attachments) throws RemotePublishingException {
        ArrayList<RemoteAttachmentManifest> attachmentsToRemove = new ArrayList<RemoteAttachmentManifest>();
        List<RemoteAttachmentManifest> pageManifestAttachments = pageManifest.getAttachments();
        if (Objects.isNull(pageManifestAttachments)) {
            return;
        }
        for (RemoteAttachmentManifest remoteAttachment : pageManifestAttachments) {
            Optional<Attachment> currentAttachment = attachments.stream().filter(attachment -> attachment.getFileName().equals(remoteAttachment.getFilename())).findFirst();
            if (currentAttachment.isPresent()) continue;
            this.remotePublisherService.deleteAttachment(remoteAttachment.getId());
            attachmentsToRemove.add(remoteAttachment);
        }
        pageManifestAttachments.removeAll(attachmentsToRemove);
    }

    private void updateOrAddAttachments(RemotePageManifest pageManifest, List<Attachment> attachments) throws IOException, RemotePublishingException {
        for (Attachment currentAttachment : attachments) {
            RemoteAttachmentManifest remoteAttachment = pageManifest.getAttachments().stream().filter(remoteAttachmentManifest -> currentAttachment.getIdAsString().equals(remoteAttachmentManifest.getLocalId())).findFirst().orElse(null);
            if (remoteAttachment == null) {
                remoteAttachment = pageManifest.getAttachments().stream().filter(remoteAttachmentManifest -> currentAttachment.getFileName().equals(remoteAttachmentManifest.getFilename())).findFirst().orElse(null);
            }
            if (remoteAttachment != null) {
                remoteAttachment.setLocalId(currentAttachment.getIdAsString());
                if (remoteAttachment.equalsAttachment(currentAttachment)) continue;
                this.remotePublisherService.updateAttachment(pageManifest.getPageId(), currentAttachment, remoteAttachment, this.getAttachmentData(currentAttachment));
                continue;
            }
            RemoteAttachmentManifest remoteAttachmentManifest2 = this.remotePublisherService.addAttachment(pageManifest.getPageId(), currentAttachment, this.getAttachmentData(currentAttachment));
            pageManifest.addAttachment(remoteAttachmentManifest2);
        }
    }

    private byte[] getAttachmentData(Attachment attachment) throws IOException {
        int len;
        InputStream is;
        byte[] data = new byte[(int)attachment.getFileSize()];
        try {
            is = this.attachmentManager.getAttachmentData(attachment);
        }
        catch (Exception e) {
            throw new IOException();
        }
        if (is == null) {
            throw new IOException();
        }
        int offset = 0;
        while ((len = is.available()) > 0) {
            int read = is.read(data, offset, len);
            offset += read;
        }
        return data;
    }

    private Optional<DiagramProcessor> getDiagramProcessor() {
        return Optional.of(new DrawIoProcessor(this.attachmentManager, this.xhtmlContent));
    }

    private boolean isDiagramMacro(String body, Predicate<String> macroCheck) {
        if (body == null) {
            return false;
        }
        return macroCheck.test(body);
    }
}

