/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.model.converter;

import com.comalatech.confluence.remotepublishing.model.PublishHistoryInfo;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingHistoryInfoConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(PublishingHistoryInfoConverter.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        PublishHistoryInfo publishHistoryInfo = (PublishHistoryInfo)source;
        if (publishHistoryInfo.getPublishDate() != null) {
            writer.startNode("publishDate");
            writer.setValue(DATE_FORMAT.format(publishHistoryInfo.getPublishDate()));
            writer.endNode();
        }
        if (publishHistoryInfo.getRemotePageManifest() != null) {
            writer.startNode("page");
            context.convertAnother((Object)publishHistoryInfo.getRemotePageManifest());
            writer.endNode();
        }
        if (publishHistoryInfo.getPublishUrl() != null) {
            writer.startNode("publishUrl");
            writer.setValue(publishHistoryInfo.getPublishUrl());
            writer.endNode();
        }
        if (publishHistoryInfo.getEntityLinkKey() != null) {
            writer.startNode("entityLinkKey");
            writer.setValue(publishHistoryInfo.getEntityLinkKey());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        PublishHistoryInfo publishHistoryInfo = new PublishHistoryInfo();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if ("publishDate".equals(nodeName)) {
                try {
                    publishHistoryInfo.setPublishDate(DATE_FORMAT.parse(reader.getValue()));
                }
                catch (ParseException e) {
                    log.error("Error parsing the publish date {}", (Object)e.getMessage());
                }
            } else if ("page".equals(nodeName) || "remotePageManifest".equals(nodeName)) {
                publishHistoryInfo.setRemotePageManifest((RemotePageManifest)context.convertAnother((Object)publishHistoryInfo, RemotePageManifest.class));
            } else if ("entityLinkKey".equals(nodeName)) {
                publishHistoryInfo.setEntityLinkKey(reader.getValue());
            } else if ("publishUrl".equals(nodeName)) {
                publishHistoryInfo.setPublishUrl(reader.getValue());
            }
            reader.moveUp();
        }
        return publishHistoryInfo;
    }

    public boolean canConvert(Class type) {
        return PublishHistoryInfo.class.isAssignableFrom(type);
    }
}

