/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.macro;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.remotepublishing.license.RemotePublishingLicenseManager;
import com.comalatech.confluence.remotepublishing.macro.RemotePublishingMacroHelper;
import com.comalatech.confluence.remotepublishing.macro.templates.NoBodyBaseMacro;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemotePublishingNoBodyBaseMacro
extends NoBodyBaseMacro {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemotePublishingNoBodyBaseMacro.class);
    private RemotePublishingLicenseManager licenseManager;
    protected RemotePublishingMacroHelper remotePublishingMacroHelper;

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        if (this.isAppLicensed()) {
            return this.doExecute(parameters, renderContext);
        }
        String licenseMessage = this.licenseManager.getLicenseMessage();
        log.warn(licenseMessage);
        this.remotePublishingMacroHelper.logErrorMessageToWorkflowEngine(licenseMessage, renderContext);
        throw new MacroException(licenseMessage);
    }

    protected abstract String doExecute(Map var1, RenderContext var2) throws MacroException;

    private boolean isAppLicensed() {
        return this.licenseManager.isLicensed();
    }

    public void setLicenseManager(RemotePublishingLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setRemotePublishingMacroHelper(RemotePublishingMacroHelper remotePublishingMacroHelper) {
        this.remotePublishingMacroHelper = remotePublishingMacroHelper;
    }
}

