/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.macro;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfigurationManager;
import com.comalatech.confluence.remotepublishing.credentials.models.UserCredentials;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RemotePublishingMacroHelper {
    private static final String LOG_KEY = "com.comalatech.log";
    private static final String PROPERTIES_KEY = "com.comalatech.workflow.properties.publishing";
    private static final String EXECUTE_KEY = "com.comalatech.execute";
    private final RemotePublishingConfigurationManager remotePublishingConfigurationManager;

    public RemotePublishingMacroHelper(RemotePublishingConfigurationManager remotePublishingConfigurationManager) {
        this.remotePublishingConfigurationManager = remotePublishingConfigurationManager;
    }

    public RemotePublishingConfiguration getRemoteCredentials(Map<String, Object> parameters, RenderContext renderContext) {
        RemotePublishingConfiguration config = null;
        if (renderContext instanceof PageContext) {
            Map properties;
            PageContext pageContext = (PageContext)renderContext;
            String configName = (String)parameters.get("0");
            config = this.remotePublishingConfigurationManager.getSpaceConfiguration(pageContext.getSpaceKey(), configName);
            if (config == null && null != (properties = (Map)renderContext.getParam((Object)PROPERTIES_KEY))) {
                config = new RemotePublishingConfiguration("", new UserCredentials(properties));
            }
            if (null != config && null != config.getCredentials()) {
                config.getCredentials().override(parameters);
            }
        }
        return config;
    }

    public void logErrorMessageToWorkflowEngine(String message, RenderContext renderContext) {
        String existingMessage = (String)renderContext.getParam((Object)LOG_KEY);
        if (StringUtils.isNotBlank((CharSequence)existingMessage)) {
            message = existingMessage + "\n" + message;
        }
        renderContext.addParam((Object)LOG_KEY, (Object)message);
    }

    public boolean isNotInExecuteMode(RenderContext renderContext) {
        return null == renderContext.getParam((Object)EXECUTE_KEY);
    }
}

