/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.config;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.compat.setup.xstream.XStreamManagerCompat;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfigurationManager;
import com.comalatech.confluence.remotepublishing.config.converter.RemotePublishingConfigurationConverter;
import com.comalatech.confluence.remotepublishing.credentials.converter.CredentialsConverter;
import com.comalatech.confluence.remotepublishing.model.converter.PublishingHistoryInfoConverter;
import com.comalatech.confluence.remotepublishing.utils.AESEncrypter;
import com.comalatech.confluence.remotepublishing.utils.PluginContainerManager;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemotePublishingConfigurationManager
implements RemotePublishingConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemotePublishingConfigurationManager.class);
    private static final String BANDANA_KEY = "com.comalatech.confluence.remotepublishing.config";
    private final BandanaManager bandanaManager;
    private final AESEncrypter aesEncrypter;
    private XStreamManagerCompat xStreamManagerCompat;

    public DefaultRemotePublishingConfigurationManager(BandanaManager bandanaManager, AESEncrypter aesEncrypter) {
        this.bandanaManager = bandanaManager;
        this.aesEncrypter = aesEncrypter;
    }

    @Override
    public List<RemotePublishingConfiguration> getSpaceConfigurations(String spaceKey) {
        return new ArrayList<RemotePublishingConfiguration>(this.getSpaceConfigs(spaceKey).values());
    }

    @Override
    public RemotePublishingConfiguration getSpaceConfiguration(String spaceKey, String configurationName) {
        return this.getSpaceConfigs(spaceKey).get(configurationName);
    }

    @Override
    public void putSpaceConfiguration(String spaceKey, RemotePublishingConfiguration config) {
        Map<String, RemotePublishingConfiguration> spaceConfigs = this.getSpaceConfigs(spaceKey);
        spaceConfigs.put(config.getName(), config);
        this.saveSpaceConfigs(spaceKey, spaceConfigs);
    }

    @Override
    public void removeSpaceConfiguration(String spaceKey, String configName) {
        Map<String, RemotePublishingConfiguration> spaceConfigs = this.getSpaceConfigs(spaceKey);
        spaceConfigs.remove(configName);
        this.saveSpaceConfigs(spaceKey, spaceConfigs);
    }

    protected Map<String, RemotePublishingConfiguration> getSpaceConfigs(String spaceKey) {
        String bandanaValue = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), BANDANA_KEY);
        if (StringUtils.isBlank((CharSequence)bandanaValue)) {
            return new LinkedHashMap<String, RemotePublishingConfiguration>();
        }
        if (this.xStreamManagerCompat == null) {
            this.initXStreamManagerCompat();
        }
        Object xstreamObject = this.xStreamManagerCompat.fromXML(bandanaValue);
        Map<String, RemotePublishingConfiguration> spaceConfigs = (Map<String, RemotePublishingConfiguration>)xstreamObject;
        spaceConfigs = this.decryption(spaceConfigs);
        return spaceConfigs;
    }

    protected void saveSpaceConfigs(String spaceKey, Map<String, RemotePublishingConfiguration> configs) {
        configs = this.encryption(configs);
        String saveData = "";
        if (configs != null) {
            if (this.xStreamManagerCompat == null) {
                this.initXStreamManagerCompat();
            }
            saveData = this.xStreamManagerCompat.toXML(configs);
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), BANDANA_KEY, (Object)saveData);
    }

    protected Map<String, RemotePublishingConfiguration> encryption(Map<String, RemotePublishingConfiguration> config) {
        LinkedHashMap<String, RemotePublishingConfiguration> encryptionConfig = new LinkedHashMap<String, RemotePublishingConfiguration>();
        config.forEach((configName, configValue) -> encryptionConfig.put((String)configName, this.aesEncrypter.encryptRemotePublishingConfiguration((RemotePublishingConfiguration)configValue)));
        return encryptionConfig;
    }

    protected Map<String, RemotePublishingConfiguration> decryption(Map<String, RemotePublishingConfiguration> config) {
        LinkedHashMap<String, RemotePublishingConfiguration> decryptionConfig = new LinkedHashMap<String, RemotePublishingConfiguration>();
        config.forEach((configName, configValue) -> {
            try {
                decryptionConfig.put((String)configName, this.aesEncrypter.decryptRemotePublishingConfiguration((RemotePublishingConfiguration)configValue));
            }
            catch (RemotePublishingException e) {
                log.error("Error while decrypting the configuration", e.getCause() != null ? e.getCause() : e);
            }
        });
        return decryptionConfig;
    }

    private void initXStreamManagerCompat() {
        this.xStreamManagerCompat = PluginContainerManager.getComponent("xStreamManagerCompat", XStreamManagerCompat.class);
        this.registerCustomConverter();
    }

    private void registerCustomConverter() {
        this.xStreamManagerCompat.getXStream().allowTypesByWildcard(new String[]{"com.comalatech.confluence.remotepublishing.**"});
        this.xStreamManagerCompat.registerConverter((Converter)new CredentialsConverter(), Integer.valueOf(1));
        this.xStreamManagerCompat.registerConverter((Converter)new RemotePublishingConfigurationConverter(), Integer.valueOf(1));
        this.xStreamManagerCompat.registerConverter((Converter)new PublishingHistoryInfoConverter(), Integer.valueOf(1));
    }
}

