/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.remotepublishing.applink.AppLinkService;
import com.comalatech.confluence.remotepublishing.applink.RemotePublishingAppLinkService;
import com.comalatech.confluence.remotepublishing.utils.enums.DarkFeatureKey;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ConfluenceRemotePublishingAppLinkService
implements RemotePublishingAppLinkService {
    private final AppLinkService appLinkService;
    private final DarkFeatureManager darkFeatureManager;

    public ConfluenceRemotePublishingAppLinkService(AppLinkService appLinkService, DarkFeatureManager darkFeatureManager) {
        this.appLinkService = appLinkService;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public List<ApplicationLink> getApplicationLinks() {
        if (!this.appLinkDarkFeatureEnabled()) {
            return Collections.emptyList();
        }
        return this.appLinkService.getAppConnections();
    }

    @Override
    public boolean isActiveApplinkConnection(String spaceKey, String entityLinkKey) {
        return Objects.nonNull(this.getEntityLink(entityLinkKey, spaceKey));
    }

    @Override
    public ApplicationLink getApplink(String entityLinkKey) throws TypeNotInstalledException {
        return this.appLinkService.getAppConnection(entityLinkKey);
    }

    @Override
    public boolean appLinkDarkFeatureEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers(DarkFeatureKey.APP_LINK.getKey()).orElse(false);
    }

    @Override
    public List<EntityLink> getEntityLinks(String spaceKey) {
        if (!this.appLinkDarkFeatureEnabled()) {
            return Collections.emptyList();
        }
        return this.appLinkService.getSpaceEntityLinks(spaceKey);
    }

    @Override
    public EntityLink getEntityLink(String configurationEntityLinkKey, String spaceKey) {
        return this.appLinkService.getEntityLinkForSpaceAndKey(spaceKey, configurationEntityLinkKey);
    }
}

