/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.comalatech.confluence.remotepublishing.CommonRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.PublishHistoryManager;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.confluence.RemotePublisherService;
import com.comalatech.confluence.remotepublishing.utils.RestConnectionCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class RestRemotePublishingManager
extends CommonRemotePublishingManager {
    private static final Logger log = LoggerFactory.getLogger(RestRemotePublishingManager.class);

    public RestRemotePublishingManager(AttachmentManager attachmentManager, PublishHistoryManager publishHistoryManager, XhtmlContent xhtmlContent, @Qualifier(value="restRemotePublisher") RemotePublisherService remotePublisherService) {
        super(remotePublisherService, publishHistoryManager, attachmentManager, xhtmlContent);
    }

    @Override
    public void checkCredentials(RemotePublishingConfiguration config, String spaceKey) {
        new RestConnectionCommand(this.remotePublisherService, config.getCredentials(), spaceKey, config.getName()){

            @Override
            public void doExecute() {
                RestRemotePublishingManager.this.checkCredentials();
            }
        }.execute();
    }

    @Override
    public void unpublish(final RemotePublishingConfiguration config, final AbstractPage page, final boolean purgeFromTrash) throws RemotePublishingException {
        log.debug("Unpublishing '{}'({}) {}", new Object[]{page.getTitle(), page.getSpaceKey(), purgeFromTrash});
        new RestConnectionCommand(this.remotePublisherService, config.getCredentials(), page.getSpaceKey(), config.getName()){

            @Override
            public void doExecute() {
                RestRemotePublishingManager.this.unpublish(page, config.getCredentials(), config.getName(), purgeFromTrash);
            }
        }.execute();
    }

    @Override
    public void publish(final RemotePublishingConfiguration config, final AbstractPage absPage) throws RemotePublishingException {
        log.debug("Publishing page or blogpost '{}'({})", (Object)absPage.getTitle(), (Object)absPage.getSpaceKey());
        log.debug("Credentials: {}", (Object)config.getCredentials());
        new RestConnectionCommand(this.remotePublisherService, config.getCredentials(), absPage.getSpaceKey(), config.getName()){

            @Override
            public void doExecute() {
                RestRemotePublishingManager.this.publish(absPage, config.getCredentials(), config.getName());
            }
        }.execute();
    }

    void checkCredentials() {
        this.remotePublisherService.checkRemoteSpace();
        this.remotePublisherService.checkRemoteSpacePermissions();
    }
}

