/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils.factory;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.DarkFeatureKey;
import org.springframework.beans.factory.annotation.Qualifier;

public class ApiActionFactory {
    private final DarkFeatureManager darkFeatureManager;
    private final ApiAction baseRestApiAction;
    private final ApiAction proxiedRestApiAction;

    public ApiActionFactory(DarkFeatureManager darkFeatureManager, @Qualifier(value="baseRestApiAction") ApiAction baseRestApiAction, @Qualifier(value="proxiedRestApiAction") ApiAction proxiedRestApiAction) {
        this.darkFeatureManager = darkFeatureManager;
        this.baseRestApiAction = baseRestApiAction;
        this.proxiedRestApiAction = proxiedRestApiAction;
    }

    public ApiAction getApiAction() {
        boolean proxyEnabled = this.darkFeatureManager.isEnabledForAllUsers(DarkFeatureKey.PROXY_SUPPORT_ENABLED.getKey()).orElse(false);
        if (proxyEnabled) {
            return this.proxiedRestApiAction;
        }
        return this.baseRestApiAction;
    }
}

