/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.confluence.RemotePublisherService;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.credentials.models.UserCredentials;
import com.comalatech.confluence.remotepublishing.utils.ConnectionCommand;

public abstract class RestConnectionCommand
extends ConnectionCommand {
    private boolean connectionEstablished = false;

    public RestConnectionCommand(RemotePublisherService restRemotePublisherService, Credentials credentials, String spaceKey, String configName) {
        super(restRemotePublisherService, credentials, spaceKey, configName);
    }

    @Override
    protected void validateCredentials() {
        this.validateCredentialsAndSetDefaults((UserCredentials)this.credentials);
        this.remotePublisherService.setCredentials(this.credentials, this.spaceKey, this.configName);
    }

    @Override
    protected ConnectionCommand prepareConnection() {
        this.remotePublisherService.doLogin();
        this.connectionEstablished = true;
        return this;
    }

    private void validateCredentialsAndSetDefaults(UserCredentials credentials) {
        if (credentials.getRemoteUserName() == null) {
            credentials.setRemoteUserName(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            credentials.validate();
        }
        catch (NoSuchFieldException e) {
            throw new RemotePublishingException("No such field exception: " + e.getMessage());
        }
    }
}

