/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.Response;
import com.comalatech.confluence.remotepublishing.applink.AppLinkService;
import com.comalatech.confluence.remotepublishing.credentials.models.AppLinkCredentials;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplinkApiAction
implements ApiAction {
    private static final Logger log = LoggerFactory.getLogger(ApplinkApiAction.class);
    private final AppLinkService appLinkService;
    private final AttachmentManager attachmentManager;
    private AppLinkCredentials credentials;
    private String spaceKey;

    public ApplinkApiAction(AppLinkService appLinkService, AttachmentManager attachmentManager) {
        this.appLinkService = appLinkService;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public void setRemoteCredentials(Credentials credentials, String spaceKey) {
        this.credentials = (AppLinkCredentials)credentials;
        this.spaceKey = spaceKey;
    }

    @Override
    public JsonObject httpGetPetition(ConfluenceRestAPI petitionType, boolean getJson, boolean useToken, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doGetRequest(formattedUrl, getJson);
    }

    @Override
    public JsonObject httpGetPetition(String url, boolean getJson, boolean useToken, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(url, urlParameters);
        return this.doGetRequest(formattedUrl, getJson);
    }

    @Override
    public JsonObject httpPostPetition(ConfluenceRestAPI petitionType, boolean getJson, boolean removeAtlassianTokenCheck, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPostRequest(formattedUrl, getJson, null, null, null);
    }

    @Override
    public JsonObject httpPostPetition(StringEntity stringEntity, ConfluenceRestAPI petitionType, boolean getJson, boolean removeAtlassianTokenCheck, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPostRequest(formattedUrl, getJson, stringEntity, null, null);
    }

    @Override
    public JsonObject httpPostPetition(List<NameValuePair> form, ConfluenceRestAPI petitionType, boolean getJson, boolean useToken) {
        UrlEncodedFormEntity stringEntity = new UrlEncodedFormEntity(form, StandardCharsets.UTF_8);
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), new String[0]);
        return this.doPostRequest(formattedUrl, getJson, (StringEntity)stringEntity, null, null, "application/x-www-form-urlencoded");
    }

    @Override
    public JsonObject httpPostPetition(MultipartEntityBuilder multipartEntityBuilder, ConfluenceRestAPI petitionType, boolean getJson, boolean removeAtlassianTokenCheck, Attachment attachment, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPostRequest(formattedUrl, getJson, null, multipartEntityBuilder, attachment);
    }

    @Override
    public JsonObject httpPutPetition(StringEntity stringEntity, ConfluenceRestAPI petitionType, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPutRequest(formattedUrl, stringEntity);
    }

    @Override
    public JsonObject httpDeletePetition(ConfluenceRestAPI petitionType, boolean getJson, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doDeleteRequest(formattedUrl, getJson);
    }

    private JsonObject doPostRequest(String url, boolean getJson, StringEntity stringEntity, MultipartEntityBuilder multipartEntityBuilder, Attachment attachment) {
        return this.doPostRequest(url, getJson, stringEntity, multipartEntityBuilder, attachment, "application/json");
    }

    private JsonObject doPostRequest(String url, boolean getJson, StringEntity stringEntity, MultipartEntityBuilder multipartEntityBuilder, Attachment attachment, String contentType) {
        if (log.isDebugEnabled()) {
            log.debug("Post request to {} linked to a page in space {}", (Object)url, (Object)this.credentials.getRemoteSpaceKey());
        }
        try {
            EntityLink entityLink = this.appLinkService.getEntityLinkForSpaceAndKey(this.spaceKey, this.credentials.getEntityLinkKey());
            if (entityLink == null) {
                throw new Exception("No entitylink found for space: " + this.spaceKey + ". Check your space's entitylink is properly connected to the AppLink by going to \"space tools -> integrations\" on the space");
            }
            ApplicationLinkRequestFactory authenticatedRequestFactory = entityLink.getApplicationLink().createAuthenticatedRequestFactory();
            ApplicationLinkRequest applicationLinkRequest = authenticatedRequestFactory.createRequest(Request.MethodType.POST, this.getUrlBase(entityLink) + url);
            if (multipartEntityBuilder != null && attachment != null) {
                List<RequestFilePart> requestFileParts = this.generateFilePartFromMultipartEntityBuilder(attachment);
                applicationLinkRequest.setFiles(requestFileParts);
                applicationLinkRequest.setHeader("x-atlassian-token", "no-check");
            }
            log.debug("calling Post to {},transformBoolean {}, Request Headers {}", new Object[]{url, getJson, applicationLinkRequest.getHeaders()});
            if (contentType.equals("application/x-www-form-urlencoded")) {
                applicationLinkRequest.setHeader("X-Atlassian-Token", "no-check");
            }
            if (stringEntity != null) {
                applicationLinkRequest.setRequestBody(IOUtils.toString((InputStream)stringEntity.getContent(), (Charset)StandardCharsets.UTF_8), contentType);
            }
            if (getJson) {
                return (JsonObject)applicationLinkRequest.executeAndReturn(this::getJsonFromResponse);
            }
            return (JsonObject)applicationLinkRequest.executeAndReturn(this::checkStatusCode);
        }
        catch (Exception e) {
            log.error("Error doing Post request to {}", (Object)url, (Object)e);
            return null;
        }
    }

    private JsonObject doGetRequest(String url, boolean getJson) {
        if (log.isDebugEnabled()) {
            log.debug("Get request to {} linked to a page in space {}", (Object)url, (Object)this.credentials.getRemoteSpaceKey());
        }
        try {
            EntityLink entityLink = this.appLinkService.getEntityLinkForSpaceAndKey(this.spaceKey, this.credentials.getEntityLinkKey());
            if (entityLink == null) {
                throw new Exception("No entitylink found for space: " + this.spaceKey + ". Check your space's entitylink is properly connected to the AppLink by going to \"space tools -> integrations\" on the space");
            }
            ApplicationLinkRequestFactory authenticatedRequestFactory = entityLink.getApplicationLink().createAuthenticatedRequestFactory();
            ApplicationLinkRequest applicationLinkRequest = authenticatedRequestFactory.createRequest(Request.MethodType.GET, this.getUrlBase(entityLink) + url);
            applicationLinkRequest.setHeader("Content-Type", "application/json");
            if (getJson) {
                return (JsonObject)applicationLinkRequest.executeAndReturn(this::getJsonFromResponse);
            }
            return (JsonObject)applicationLinkRequest.executeAndReturn(this::checkStatusCode);
        }
        catch (Exception e) {
            log.error("Error at doGetConnection", (Throwable)e);
            return null;
        }
    }

    private JsonObject doPutRequest(String url, StringEntity stringEntity) {
        try {
            EntityLink entityLink = this.appLinkService.getEntityLinkForSpaceAndKey(this.spaceKey, this.credentials.getEntityLinkKey());
            if (entityLink == null) {
                throw new Exception("No entitylink found for space: " + this.spaceKey + ". Check your space's entitylink is properly connected to the AppLink by going to \"space tools -> integrations\" on the space");
            }
            ApplicationLinkRequestFactory authenticatedRequestFactory = entityLink.getApplicationLink().createAuthenticatedRequestFactory();
            ApplicationLinkRequest applicationLinkRequest = authenticatedRequestFactory.createRequest(Request.MethodType.PUT, this.getUrlBase(entityLink) + url);
            log.debug("calling Put to {} , Request headers {}", (Object)url, (Object)applicationLinkRequest.getHeaders());
            if (stringEntity != null) {
                applicationLinkRequest.setRequestBody(IOUtils.toString((InputStream)stringEntity.getContent(), (Charset)StandardCharsets.UTF_8), "application/json");
            }
            return (JsonObject)applicationLinkRequest.executeAndReturn(this::getJsonFromResponse);
        }
        catch (Exception ex) {
            log.error("error on post request {}", (Object)url, (Object)ex);
            return null;
        }
    }

    private JsonObject doDeleteRequest(String url, boolean getJson) {
        try {
            EntityLink entityLink = this.appLinkService.getEntityLinkForSpaceAndKey(this.spaceKey, this.credentials.getEntityLinkKey());
            if (entityLink == null) {
                throw new Exception("No entitylink found for space: " + this.spaceKey + ". Check your space's entitylink is properly connected to the AppLink by going to \"space tools -> integrations\" on the space");
            }
            ApplicationLinkRequestFactory authenticatedRequestFactory = entityLink.getApplicationLink().createAuthenticatedRequestFactory();
            ApplicationLinkRequest applicationLinkRequest = authenticatedRequestFactory.createRequest(Request.MethodType.DELETE, this.getUrlBase(entityLink) + url);
            log.debug("calling Delete to {} , Request headers {}", (Object)url, (Object)applicationLinkRequest.getHeaders());
            if (getJson) {
                return (JsonObject)applicationLinkRequest.executeAndReturn(this::getJsonFromResponse);
            }
            return (JsonObject)applicationLinkRequest.executeAndReturn(this::checkStatusCode);
        }
        catch (Exception e) {
            log.error("error making post call to  {}", (Object)url, (Object)e);
            return null;
        }
    }

    private JsonObject getJsonFromResponse(Response response) {
        try {
            String jsonString = response.getResponseBodyAsString();
            log.debug("Response status {} , Response Headers {} ,ResponseBody {} ,", new Object[]{response.getStatusCode(), response.getHeaders(), jsonString});
            JsonParser parser = new JsonParser();
            JsonElement resultObject = parser.parse(jsonString);
            if (resultObject instanceof JsonObject) {
                return (JsonObject)resultObject;
            }
            return null;
        }
        catch (Exception e) {
            log.error("error getting json from entity", e.getCause());
            return null;
        }
    }

    private JsonObject checkStatusCode(Response response) {
        int statusCode = response.getStatusCode();
        if (statusCode != 200 && statusCode != 202 && statusCode != 204 && statusCode != 302) {
            return null;
        }
        return new JsonObject();
    }

    private String getUrlBase(EntityLink entityLink) {
        String fullUrl = entityLink.getDisplayUrl().toString();
        return fullUrl.substring(0, fullUrl.indexOf("/display"));
    }

    private String generatePageUrl(String urlFormat, String ... urlParameters) {
        if (urlParameters.length == 0) {
            return urlFormat;
        }
        this.encodeParameters(urlParameters);
        MessageFormat messageFormat = new MessageFormat(urlFormat);
        return messageFormat.format(urlParameters);
    }

    private void encodeParameters(String ... urlParameters) {
        try {
            for (int i = 0; i < urlParameters.length; ++i) {
                urlParameters[i] = URLEncoder.encode(urlParameters[i], "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("error encoding parameters {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<RequestFilePart> generateFilePartFromMultipartEntityBuilder(Attachment attachment) throws IOException {
        File file = File.createTempFile("attachment", ".tmp");
        InputStream attachmentData = this.attachmentManager.getAttachmentData(attachment);
        log.debug("Adding file to request ,{}", (Object)file.getAbsolutePath());
        try (FileOutputStream fo = new FileOutputStream(file);){
            IOUtils.copy((InputStream)attachmentData, (OutputStream)fo);
            RequestFilePart filePart = new RequestFilePart(attachment.getMediaType(), attachment.getFileName(), file, "file");
            List<RequestFilePart> list = Collections.singletonList(filePart);
            return list;
        }
    }
}

