/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.macro;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.remotepublishing.ApplinkRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RestRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.macro.AbstractRemotePublishingNoBodyBaseMacro;
import com.comalatech.confluence.remotepublishing.macro.RemotePublishingMacroHelper;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRemovePageMacro
extends AbstractRemotePublishingNoBodyBaseMacro {
    private static final Logger log = LoggerFactory.getLogger(RemoteRemovePageMacro.class);
    private static final String PURGE_PARAM = "purgeFromTrash";
    private RestRemotePublishingManager restRemotePublishingManager;
    private ApplinkRemotePublishingManager applinkRemotePublishingManager;
    private RemotePublishingMacroHelper remotePublishingMacroHelper;

    @Override
    public String doExecute(Map parameters, RenderContext renderContext) throws MacroException {
        boolean purgeFromTrash = MapUtils.getBooleanValue((Map)parameters, (Object)PURGE_PARAM, (boolean)false);
        if (this.remotePublishingMacroHelper.isNotInExecuteMode(renderContext)) {
            return "";
        }
        try {
            RemotePublishingConfiguration config = this.remotePublishingMacroHelper.getRemoteCredentials(parameters, renderContext);
            if (config == null) {
                throw new MacroException("need to define remote publishing configuration before using remotepublishing macro");
            }
            AbstractPage page = this.getAbstractPage(renderContext);
            if (config.isAppLinkCredential()) {
                this.applinkRemotePublishingManager.unpublish(config, page, purgeFromTrash);
            } else {
                this.restRemotePublishingManager.unpublish(config, page, purgeFromTrash);
            }
        }
        catch (RemotePublishingException e) {
            this.remotePublishingMacroHelper.logErrorMessageToWorkflowEngine(e.getMessage(), renderContext);
            throw new MacroException(e.getMessage());
        }
        catch (Exception e) {
            this.remotePublishingMacroHelper.logErrorMessageToWorkflowEngine(e.toString(), renderContext);
            log.error(e.getMessage(), (Throwable)e);
            throw new MacroException((Throwable)e);
        }
        return "";
    }

    @Override
    public void setRemotePublishingMacroHelper(RemotePublishingMacroHelper remotePublishingMacroHelper) {
        this.remotePublishingMacroHelper = remotePublishingMacroHelper;
    }

    public void setRestRemotePublishingManager(RestRemotePublishingManager restRemotePublishingManager) {
        this.restRemotePublishingManager = restRemotePublishingManager;
    }

    public void setApplinkRemotePublishingManager(ApplinkRemotePublishingManager applinkRemotePublishingManager) {
        this.applinkRemotePublishingManager = applinkRemotePublishingManager;
    }
}

