/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.macro;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.remotepublishing.ApplinkRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RestRemotePublishingManager;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.macro.AbstractRemotePublishingNoBodyBaseMacro;
import com.comalatech.confluence.remotepublishing.macro.RemotePublishingMacroHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePublishPageMacro
extends AbstractRemotePublishingNoBodyBaseMacro {
    private static final Logger log = LoggerFactory.getLogger(RemotePublishPageMacro.class);
    private RestRemotePublishingManager restRemotePublishingManager;
    private ApplinkRemotePublishingManager applinkRemotePublishingManager;
    private RemotePublishingMacroHelper remotePublishingMacroHelper;

    @Override
    protected String doExecute(Map parameters, RenderContext renderContext) throws MacroException {
        if (this.remotePublishingMacroHelper.isNotInExecuteMode(renderContext)) {
            return "";
        }
        try {
            RemotePublishingConfiguration config = this.remotePublishingMacroHelper.getRemoteCredentials(parameters, renderContext);
            if (config == null) {
                throw new MacroException("need to define remote publishing configuration before using remotepublishing macro");
            }
            AbstractPage page = this.getAbstractPage(renderContext);
            if (config.isAppLinkCredential()) {
                this.applinkRemotePublishingManager.publish(config, page);
            } else {
                this.restRemotePublishingManager.publish(config, page);
            }
        }
        catch (RemotePublishingException e) {
            log.error(e.getMessage(), e.getCause());
            this.remotePublishingMacroHelper.logErrorMessageToWorkflowEngine(e.getMessage(), renderContext);
            throw new MacroException(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.remotePublishingMacroHelper.logErrorMessageToWorkflowEngine(e.toString(), renderContext);
            throw new MacroException(e.getMessage());
        }
        return "";
    }

    @Override
    public void setRemotePublishingMacroHelper(RemotePublishingMacroHelper remotePublishingMacroHelper) {
        this.remotePublishingMacroHelper = remotePublishingMacroHelper;
    }

    public void setRestRemotePublishingManager(RestRemotePublishingManager restRemotePublishingManager) {
        this.restRemotePublishingManager = restRemotePublishingManager;
    }

    public void setApplinkRemotePublishingManager(ApplinkRemotePublishingManager applinkRemotePublishingManager) {
        this.applinkRemotePublishingManager = applinkRemotePublishingManager;
    }
}

